import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/app#app_id DataDigitaloceanApp#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/app#id DataDigitaloceanApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataDigitaloceanAppSpecAlert {
}
export declare function dataDigitaloceanAppSpecAlertToTerraform(struct?: DataDigitaloceanAppSpecAlert): any;
export declare class DataDigitaloceanAppSpecAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecAlert | undefined;
    set internalValue(value: DataDigitaloceanAppSpecAlert | undefined);
    get disabled(): cdktf.IResolvable;
    get rule(): string;
}
export declare class DataDigitaloceanAppSpecAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecAlertOutputReference;
}
export interface DataDigitaloceanAppSpecDatabase {
}
export declare function dataDigitaloceanAppSpecDatabaseToTerraform(struct?: DataDigitaloceanAppSpecDatabase): any;
export declare class DataDigitaloceanAppSpecDatabaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecDatabase | undefined;
    set internalValue(value: DataDigitaloceanAppSpecDatabase | undefined);
    get clusterName(): string;
    get dbName(): string;
    get dbUser(): string;
    get engine(): string;
    get name(): string;
    get production(): cdktf.IResolvable;
    get version(): string;
}
export declare class DataDigitaloceanAppSpecDatabaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecDatabaseOutputReference;
}
export interface DataDigitaloceanAppSpecDomain {
}
export declare function dataDigitaloceanAppSpecDomainToTerraform(struct?: DataDigitaloceanAppSpecDomain): any;
export declare class DataDigitaloceanAppSpecDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecDomain | undefined;
    set internalValue(value: DataDigitaloceanAppSpecDomain | undefined);
    get name(): string;
    get type(): string;
    get wildcard(): cdktf.IResolvable;
    get zone(): string;
}
export declare class DataDigitaloceanAppSpecDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecDomainOutputReference;
}
export interface DataDigitaloceanAppSpecEnv {
}
export declare function dataDigitaloceanAppSpecEnvToTerraform(struct?: DataDigitaloceanAppSpecEnv): any;
export declare class DataDigitaloceanAppSpecEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecEnv | undefined;
    set internalValue(value: DataDigitaloceanAppSpecEnv | undefined);
    get key(): string;
    get scope(): string;
    get type(): string;
    get value(): string;
}
export declare class DataDigitaloceanAppSpecEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecEnvOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionAlert {
}
export declare function dataDigitaloceanAppSpecFunctionAlertToTerraform(struct?: DataDigitaloceanAppSpecFunctionAlert): any;
export declare class DataDigitaloceanAppSpecFunctionAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionAlert | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionAlert | undefined);
    get disabled(): cdktf.IResolvable;
    get operator(): string;
    get rule(): string;
    get value(): number;
    get window(): string;
}
export declare class DataDigitaloceanAppSpecFunctionAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionAlertOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionCorsAllowOrigins {
}
export declare function dataDigitaloceanAppSpecFunctionCorsAllowOriginsToTerraform(struct?: DataDigitaloceanAppSpecFunctionCorsAllowOrigins): any;
export declare class DataDigitaloceanAppSpecFunctionCorsAllowOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionCorsAllowOrigins | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionCorsAllowOrigins | undefined);
    get exact(): string;
    get prefix(): string;
    get regex(): string;
}
export declare class DataDigitaloceanAppSpecFunctionCorsAllowOriginsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionCorsAllowOriginsOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionCors {
}
export declare function dataDigitaloceanAppSpecFunctionCorsToTerraform(struct?: DataDigitaloceanAppSpecFunctionCors): any;
export declare class DataDigitaloceanAppSpecFunctionCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionCors | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionCors | undefined);
    get allowCredentials(): cdktf.IResolvable;
    get allowHeaders(): string[];
    get allowMethods(): string[];
    private _allowOrigins;
    get allowOrigins(): DataDigitaloceanAppSpecFunctionCorsAllowOriginsList;
    get exposeHeaders(): string[];
    get maxAge(): string;
}
export declare class DataDigitaloceanAppSpecFunctionCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionCorsOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionEnv {
}
export declare function dataDigitaloceanAppSpecFunctionEnvToTerraform(struct?: DataDigitaloceanAppSpecFunctionEnv): any;
export declare class DataDigitaloceanAppSpecFunctionEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionEnv | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionEnv | undefined);
    get key(): string;
    get scope(): string;
    get type(): string;
    get value(): string;
}
export declare class DataDigitaloceanAppSpecFunctionEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionEnvOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionGit {
}
export declare function dataDigitaloceanAppSpecFunctionGitToTerraform(struct?: DataDigitaloceanAppSpecFunctionGit): any;
export declare class DataDigitaloceanAppSpecFunctionGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionGit | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionGit | undefined);
    get branch(): string;
    get repoCloneUrl(): string;
}
export declare class DataDigitaloceanAppSpecFunctionGitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionGitOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionGithub {
}
export declare function dataDigitaloceanAppSpecFunctionGithubToTerraform(struct?: DataDigitaloceanAppSpecFunctionGithub): any;
export declare class DataDigitaloceanAppSpecFunctionGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionGithub | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionGithub | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecFunctionGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionGithubOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionGitlab {
}
export declare function dataDigitaloceanAppSpecFunctionGitlabToTerraform(struct?: DataDigitaloceanAppSpecFunctionGitlab): any;
export declare class DataDigitaloceanAppSpecFunctionGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionGitlab | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionGitlab | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecFunctionGitlabList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionGitlabOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionLogDestinationDatadog {
}
export declare function dataDigitaloceanAppSpecFunctionLogDestinationDatadogToTerraform(struct?: DataDigitaloceanAppSpecFunctionLogDestinationDatadog): any;
export declare class DataDigitaloceanAppSpecFunctionLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionLogDestinationDatadog | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionLogDestinationDatadog | undefined);
    get apiKey(): string;
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecFunctionLogDestinationDatadogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionLogDestinationDatadogOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionLogDestinationLogtail {
}
export declare function dataDigitaloceanAppSpecFunctionLogDestinationLogtailToTerraform(struct?: DataDigitaloceanAppSpecFunctionLogDestinationLogtail): any;
export declare class DataDigitaloceanAppSpecFunctionLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionLogDestinationLogtail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionLogDestinationLogtail | undefined);
    get token(): string;
}
export declare class DataDigitaloceanAppSpecFunctionLogDestinationLogtailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionLogDestinationLogtailOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionLogDestinationPapertrail {
}
export declare function dataDigitaloceanAppSpecFunctionLogDestinationPapertrailToTerraform(struct?: DataDigitaloceanAppSpecFunctionLogDestinationPapertrail): any;
export declare class DataDigitaloceanAppSpecFunctionLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionLogDestinationPapertrail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionLogDestinationPapertrail | undefined);
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecFunctionLogDestinationPapertrailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionLogDestinationPapertrailOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionLogDestination {
}
export declare function dataDigitaloceanAppSpecFunctionLogDestinationToTerraform(struct?: DataDigitaloceanAppSpecFunctionLogDestination): any;
export declare class DataDigitaloceanAppSpecFunctionLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionLogDestination | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionLogDestination | undefined);
    private _datadog;
    get datadog(): DataDigitaloceanAppSpecFunctionLogDestinationDatadogList;
    private _logtail;
    get logtail(): DataDigitaloceanAppSpecFunctionLogDestinationLogtailList;
    get name(): string;
    private _papertrail;
    get papertrail(): DataDigitaloceanAppSpecFunctionLogDestinationPapertrailList;
}
export declare class DataDigitaloceanAppSpecFunctionLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionLogDestinationOutputReference;
}
export interface DataDigitaloceanAppSpecFunctionRoutes {
}
export declare function dataDigitaloceanAppSpecFunctionRoutesToTerraform(struct?: DataDigitaloceanAppSpecFunctionRoutes): any;
export declare class DataDigitaloceanAppSpecFunctionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunctionRoutes | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunctionRoutes | undefined);
    get path(): string;
    get preservePathPrefix(): cdktf.IResolvable;
}
export declare class DataDigitaloceanAppSpecFunctionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionRoutesOutputReference;
}
export interface DataDigitaloceanAppSpecFunction {
}
export declare function dataDigitaloceanAppSpecFunctionToTerraform(struct?: DataDigitaloceanAppSpecFunction): any;
export declare class DataDigitaloceanAppSpecFunctionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecFunction | undefined;
    set internalValue(value: DataDigitaloceanAppSpecFunction | undefined);
    private _alert;
    get alert(): DataDigitaloceanAppSpecFunctionAlertList;
    private _cors;
    get cors(): DataDigitaloceanAppSpecFunctionCorsList;
    private _env;
    get env(): DataDigitaloceanAppSpecFunctionEnvList;
    private _git;
    get git(): DataDigitaloceanAppSpecFunctionGitList;
    private _github;
    get github(): DataDigitaloceanAppSpecFunctionGithubList;
    private _gitlab;
    get gitlab(): DataDigitaloceanAppSpecFunctionGitlabList;
    private _logDestination;
    get logDestination(): DataDigitaloceanAppSpecFunctionLogDestinationList;
    get name(): string;
    private _routes;
    get routes(): DataDigitaloceanAppSpecFunctionRoutesList;
    get sourceDir(): string;
}
export declare class DataDigitaloceanAppSpecFunctionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecFunctionOutputReference;
}
export interface DataDigitaloceanAppSpecJobAlert {
}
export declare function dataDigitaloceanAppSpecJobAlertToTerraform(struct?: DataDigitaloceanAppSpecJobAlert): any;
export declare class DataDigitaloceanAppSpecJobAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobAlert | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobAlert | undefined);
    get disabled(): cdktf.IResolvable;
    get operator(): string;
    get rule(): string;
    get value(): number;
    get window(): string;
}
export declare class DataDigitaloceanAppSpecJobAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobAlertOutputReference;
}
export interface DataDigitaloceanAppSpecJobEnv {
}
export declare function dataDigitaloceanAppSpecJobEnvToTerraform(struct?: DataDigitaloceanAppSpecJobEnv): any;
export declare class DataDigitaloceanAppSpecJobEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobEnv | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobEnv | undefined);
    get key(): string;
    get scope(): string;
    get type(): string;
    get value(): string;
}
export declare class DataDigitaloceanAppSpecJobEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobEnvOutputReference;
}
export interface DataDigitaloceanAppSpecJobGit {
}
export declare function dataDigitaloceanAppSpecJobGitToTerraform(struct?: DataDigitaloceanAppSpecJobGit): any;
export declare class DataDigitaloceanAppSpecJobGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobGit | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobGit | undefined);
    get branch(): string;
    get repoCloneUrl(): string;
}
export declare class DataDigitaloceanAppSpecJobGitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobGitOutputReference;
}
export interface DataDigitaloceanAppSpecJobGithub {
}
export declare function dataDigitaloceanAppSpecJobGithubToTerraform(struct?: DataDigitaloceanAppSpecJobGithub): any;
export declare class DataDigitaloceanAppSpecJobGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobGithub | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobGithub | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecJobGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobGithubOutputReference;
}
export interface DataDigitaloceanAppSpecJobGitlab {
}
export declare function dataDigitaloceanAppSpecJobGitlabToTerraform(struct?: DataDigitaloceanAppSpecJobGitlab): any;
export declare class DataDigitaloceanAppSpecJobGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobGitlab | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobGitlab | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecJobGitlabList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobGitlabOutputReference;
}
export interface DataDigitaloceanAppSpecJobImage {
}
export declare function dataDigitaloceanAppSpecJobImageToTerraform(struct?: DataDigitaloceanAppSpecJobImage): any;
export declare class DataDigitaloceanAppSpecJobImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobImage | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobImage | undefined);
    get registry(): string;
    get registryType(): string;
    get repository(): string;
    get tag(): string;
}
export declare class DataDigitaloceanAppSpecJobImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobImageOutputReference;
}
export interface DataDigitaloceanAppSpecJobLogDestinationDatadog {
}
export declare function dataDigitaloceanAppSpecJobLogDestinationDatadogToTerraform(struct?: DataDigitaloceanAppSpecJobLogDestinationDatadog): any;
export declare class DataDigitaloceanAppSpecJobLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobLogDestinationDatadog | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobLogDestinationDatadog | undefined);
    get apiKey(): string;
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecJobLogDestinationDatadogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobLogDestinationDatadogOutputReference;
}
export interface DataDigitaloceanAppSpecJobLogDestinationLogtail {
}
export declare function dataDigitaloceanAppSpecJobLogDestinationLogtailToTerraform(struct?: DataDigitaloceanAppSpecJobLogDestinationLogtail): any;
export declare class DataDigitaloceanAppSpecJobLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobLogDestinationLogtail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobLogDestinationLogtail | undefined);
    get token(): string;
}
export declare class DataDigitaloceanAppSpecJobLogDestinationLogtailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobLogDestinationLogtailOutputReference;
}
export interface DataDigitaloceanAppSpecJobLogDestinationPapertrail {
}
export declare function dataDigitaloceanAppSpecJobLogDestinationPapertrailToTerraform(struct?: DataDigitaloceanAppSpecJobLogDestinationPapertrail): any;
export declare class DataDigitaloceanAppSpecJobLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobLogDestinationPapertrail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobLogDestinationPapertrail | undefined);
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecJobLogDestinationPapertrailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobLogDestinationPapertrailOutputReference;
}
export interface DataDigitaloceanAppSpecJobLogDestination {
}
export declare function dataDigitaloceanAppSpecJobLogDestinationToTerraform(struct?: DataDigitaloceanAppSpecJobLogDestination): any;
export declare class DataDigitaloceanAppSpecJobLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJobLogDestination | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJobLogDestination | undefined);
    private _datadog;
    get datadog(): DataDigitaloceanAppSpecJobLogDestinationDatadogList;
    private _logtail;
    get logtail(): DataDigitaloceanAppSpecJobLogDestinationLogtailList;
    get name(): string;
    private _papertrail;
    get papertrail(): DataDigitaloceanAppSpecJobLogDestinationPapertrailList;
}
export declare class DataDigitaloceanAppSpecJobLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobLogDestinationOutputReference;
}
export interface DataDigitaloceanAppSpecJob {
}
export declare function dataDigitaloceanAppSpecJobToTerraform(struct?: DataDigitaloceanAppSpecJob): any;
export declare class DataDigitaloceanAppSpecJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecJob | undefined;
    set internalValue(value: DataDigitaloceanAppSpecJob | undefined);
    private _alert;
    get alert(): DataDigitaloceanAppSpecJobAlertList;
    get buildCommand(): string;
    get dockerfilePath(): string;
    private _env;
    get env(): DataDigitaloceanAppSpecJobEnvList;
    get environmentSlug(): string;
    private _git;
    get git(): DataDigitaloceanAppSpecJobGitList;
    private _github;
    get github(): DataDigitaloceanAppSpecJobGithubList;
    private _gitlab;
    get gitlab(): DataDigitaloceanAppSpecJobGitlabList;
    private _image;
    get image(): DataDigitaloceanAppSpecJobImageList;
    get instanceCount(): number;
    get instanceSizeSlug(): string;
    get kind(): string;
    private _logDestination;
    get logDestination(): DataDigitaloceanAppSpecJobLogDestinationList;
    get name(): string;
    get runCommand(): string;
    get sourceDir(): string;
}
export declare class DataDigitaloceanAppSpecJobList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecJobOutputReference;
}
export interface DataDigitaloceanAppSpecServiceAlert {
}
export declare function dataDigitaloceanAppSpecServiceAlertToTerraform(struct?: DataDigitaloceanAppSpecServiceAlert): any;
export declare class DataDigitaloceanAppSpecServiceAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceAlert | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceAlert | undefined);
    get disabled(): cdktf.IResolvable;
    get operator(): string;
    get rule(): string;
    get value(): number;
    get window(): string;
}
export declare class DataDigitaloceanAppSpecServiceAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceAlertOutputReference;
}
export interface DataDigitaloceanAppSpecServiceCorsAllowOrigins {
}
export declare function dataDigitaloceanAppSpecServiceCorsAllowOriginsToTerraform(struct?: DataDigitaloceanAppSpecServiceCorsAllowOrigins): any;
export declare class DataDigitaloceanAppSpecServiceCorsAllowOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceCorsAllowOrigins | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceCorsAllowOrigins | undefined);
    get exact(): string;
    get prefix(): string;
    get regex(): string;
}
export declare class DataDigitaloceanAppSpecServiceCorsAllowOriginsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceCorsAllowOriginsOutputReference;
}
export interface DataDigitaloceanAppSpecServiceCors {
}
export declare function dataDigitaloceanAppSpecServiceCorsToTerraform(struct?: DataDigitaloceanAppSpecServiceCors): any;
export declare class DataDigitaloceanAppSpecServiceCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceCors | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceCors | undefined);
    get allowCredentials(): cdktf.IResolvable;
    get allowHeaders(): string[];
    get allowMethods(): string[];
    private _allowOrigins;
    get allowOrigins(): DataDigitaloceanAppSpecServiceCorsAllowOriginsList;
    get exposeHeaders(): string[];
    get maxAge(): string;
}
export declare class DataDigitaloceanAppSpecServiceCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceCorsOutputReference;
}
export interface DataDigitaloceanAppSpecServiceEnv {
}
export declare function dataDigitaloceanAppSpecServiceEnvToTerraform(struct?: DataDigitaloceanAppSpecServiceEnv): any;
export declare class DataDigitaloceanAppSpecServiceEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceEnv | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceEnv | undefined);
    get key(): string;
    get scope(): string;
    get type(): string;
    get value(): string;
}
export declare class DataDigitaloceanAppSpecServiceEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceEnvOutputReference;
}
export interface DataDigitaloceanAppSpecServiceGit {
}
export declare function dataDigitaloceanAppSpecServiceGitToTerraform(struct?: DataDigitaloceanAppSpecServiceGit): any;
export declare class DataDigitaloceanAppSpecServiceGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceGit | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceGit | undefined);
    get branch(): string;
    get repoCloneUrl(): string;
}
export declare class DataDigitaloceanAppSpecServiceGitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceGitOutputReference;
}
export interface DataDigitaloceanAppSpecServiceGithub {
}
export declare function dataDigitaloceanAppSpecServiceGithubToTerraform(struct?: DataDigitaloceanAppSpecServiceGithub): any;
export declare class DataDigitaloceanAppSpecServiceGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceGithub | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceGithub | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecServiceGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceGithubOutputReference;
}
export interface DataDigitaloceanAppSpecServiceGitlab {
}
export declare function dataDigitaloceanAppSpecServiceGitlabToTerraform(struct?: DataDigitaloceanAppSpecServiceGitlab): any;
export declare class DataDigitaloceanAppSpecServiceGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceGitlab | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceGitlab | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecServiceGitlabList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceGitlabOutputReference;
}
export interface DataDigitaloceanAppSpecServiceHealthCheck {
}
export declare function dataDigitaloceanAppSpecServiceHealthCheckToTerraform(struct?: DataDigitaloceanAppSpecServiceHealthCheck): any;
export declare class DataDigitaloceanAppSpecServiceHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceHealthCheck | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceHealthCheck | undefined);
    get failureThreshold(): number;
    get httpPath(): string;
    get initialDelaySeconds(): number;
    get periodSeconds(): number;
    get successThreshold(): number;
    get timeoutSeconds(): number;
}
export declare class DataDigitaloceanAppSpecServiceHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceHealthCheckOutputReference;
}
export interface DataDigitaloceanAppSpecServiceImage {
}
export declare function dataDigitaloceanAppSpecServiceImageToTerraform(struct?: DataDigitaloceanAppSpecServiceImage): any;
export declare class DataDigitaloceanAppSpecServiceImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceImage | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceImage | undefined);
    get registry(): string;
    get registryType(): string;
    get repository(): string;
    get tag(): string;
}
export declare class DataDigitaloceanAppSpecServiceImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceImageOutputReference;
}
export interface DataDigitaloceanAppSpecServiceLogDestinationDatadog {
}
export declare function dataDigitaloceanAppSpecServiceLogDestinationDatadogToTerraform(struct?: DataDigitaloceanAppSpecServiceLogDestinationDatadog): any;
export declare class DataDigitaloceanAppSpecServiceLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceLogDestinationDatadog | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceLogDestinationDatadog | undefined);
    get apiKey(): string;
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecServiceLogDestinationDatadogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceLogDestinationDatadogOutputReference;
}
export interface DataDigitaloceanAppSpecServiceLogDestinationLogtail {
}
export declare function dataDigitaloceanAppSpecServiceLogDestinationLogtailToTerraform(struct?: DataDigitaloceanAppSpecServiceLogDestinationLogtail): any;
export declare class DataDigitaloceanAppSpecServiceLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceLogDestinationLogtail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceLogDestinationLogtail | undefined);
    get token(): string;
}
export declare class DataDigitaloceanAppSpecServiceLogDestinationLogtailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceLogDestinationLogtailOutputReference;
}
export interface DataDigitaloceanAppSpecServiceLogDestinationPapertrail {
}
export declare function dataDigitaloceanAppSpecServiceLogDestinationPapertrailToTerraform(struct?: DataDigitaloceanAppSpecServiceLogDestinationPapertrail): any;
export declare class DataDigitaloceanAppSpecServiceLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceLogDestinationPapertrail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceLogDestinationPapertrail | undefined);
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecServiceLogDestinationPapertrailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceLogDestinationPapertrailOutputReference;
}
export interface DataDigitaloceanAppSpecServiceLogDestination {
}
export declare function dataDigitaloceanAppSpecServiceLogDestinationToTerraform(struct?: DataDigitaloceanAppSpecServiceLogDestination): any;
export declare class DataDigitaloceanAppSpecServiceLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceLogDestination | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceLogDestination | undefined);
    private _datadog;
    get datadog(): DataDigitaloceanAppSpecServiceLogDestinationDatadogList;
    private _logtail;
    get logtail(): DataDigitaloceanAppSpecServiceLogDestinationLogtailList;
    get name(): string;
    private _papertrail;
    get papertrail(): DataDigitaloceanAppSpecServiceLogDestinationPapertrailList;
}
export declare class DataDigitaloceanAppSpecServiceLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceLogDestinationOutputReference;
}
export interface DataDigitaloceanAppSpecServiceRoutes {
}
export declare function dataDigitaloceanAppSpecServiceRoutesToTerraform(struct?: DataDigitaloceanAppSpecServiceRoutes): any;
export declare class DataDigitaloceanAppSpecServiceRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecServiceRoutes | undefined;
    set internalValue(value: DataDigitaloceanAppSpecServiceRoutes | undefined);
    get path(): string;
    get preservePathPrefix(): cdktf.IResolvable;
}
export declare class DataDigitaloceanAppSpecServiceRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceRoutesOutputReference;
}
export interface DataDigitaloceanAppSpecService {
}
export declare function dataDigitaloceanAppSpecServiceToTerraform(struct?: DataDigitaloceanAppSpecService): any;
export declare class DataDigitaloceanAppSpecServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecService | undefined;
    set internalValue(value: DataDigitaloceanAppSpecService | undefined);
    private _alert;
    get alert(): DataDigitaloceanAppSpecServiceAlertList;
    get buildCommand(): string;
    private _cors;
    get cors(): DataDigitaloceanAppSpecServiceCorsList;
    get dockerfilePath(): string;
    private _env;
    get env(): DataDigitaloceanAppSpecServiceEnvList;
    get environmentSlug(): string;
    private _git;
    get git(): DataDigitaloceanAppSpecServiceGitList;
    private _github;
    get github(): DataDigitaloceanAppSpecServiceGithubList;
    private _gitlab;
    get gitlab(): DataDigitaloceanAppSpecServiceGitlabList;
    private _healthCheck;
    get healthCheck(): DataDigitaloceanAppSpecServiceHealthCheckList;
    get httpPort(): number;
    private _image;
    get image(): DataDigitaloceanAppSpecServiceImageList;
    get instanceCount(): number;
    get instanceSizeSlug(): string;
    get internalPorts(): number[];
    private _logDestination;
    get logDestination(): DataDigitaloceanAppSpecServiceLogDestinationList;
    get name(): string;
    private _routes;
    get routes(): DataDigitaloceanAppSpecServiceRoutesList;
    get runCommand(): string;
    get sourceDir(): string;
}
export declare class DataDigitaloceanAppSpecServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecServiceOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteCorsAllowOrigins {
}
export declare function dataDigitaloceanAppSpecStaticSiteCorsAllowOriginsToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteCorsAllowOrigins): any;
export declare class DataDigitaloceanAppSpecStaticSiteCorsAllowOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteCorsAllowOrigins | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteCorsAllowOrigins | undefined);
    get exact(): string;
    get prefix(): string;
    get regex(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteCorsAllowOriginsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteCorsAllowOriginsOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteCors {
}
export declare function dataDigitaloceanAppSpecStaticSiteCorsToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteCors): any;
export declare class DataDigitaloceanAppSpecStaticSiteCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteCors | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteCors | undefined);
    get allowCredentials(): cdktf.IResolvable;
    get allowHeaders(): string[];
    get allowMethods(): string[];
    private _allowOrigins;
    get allowOrigins(): DataDigitaloceanAppSpecStaticSiteCorsAllowOriginsList;
    get exposeHeaders(): string[];
    get maxAge(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteCorsOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteEnv {
}
export declare function dataDigitaloceanAppSpecStaticSiteEnvToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteEnv): any;
export declare class DataDigitaloceanAppSpecStaticSiteEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteEnv | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteEnv | undefined);
    get key(): string;
    get scope(): string;
    get type(): string;
    get value(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteEnvOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteGit {
}
export declare function dataDigitaloceanAppSpecStaticSiteGitToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteGit): any;
export declare class DataDigitaloceanAppSpecStaticSiteGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteGit | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteGit | undefined);
    get branch(): string;
    get repoCloneUrl(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteGitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteGitOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteGithub {
}
export declare function dataDigitaloceanAppSpecStaticSiteGithubToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteGithub): any;
export declare class DataDigitaloceanAppSpecStaticSiteGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteGithub | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteGithub | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteGithubOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteGitlab {
}
export declare function dataDigitaloceanAppSpecStaticSiteGitlabToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteGitlab): any;
export declare class DataDigitaloceanAppSpecStaticSiteGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteGitlab | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteGitlab | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteGitlabList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteGitlabOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSiteRoutes {
}
export declare function dataDigitaloceanAppSpecStaticSiteRoutesToTerraform(struct?: DataDigitaloceanAppSpecStaticSiteRoutes): any;
export declare class DataDigitaloceanAppSpecStaticSiteRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSiteRoutes | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSiteRoutes | undefined);
    get path(): string;
    get preservePathPrefix(): cdktf.IResolvable;
}
export declare class DataDigitaloceanAppSpecStaticSiteRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteRoutesOutputReference;
}
export interface DataDigitaloceanAppSpecStaticSite {
}
export declare function dataDigitaloceanAppSpecStaticSiteToTerraform(struct?: DataDigitaloceanAppSpecStaticSite): any;
export declare class DataDigitaloceanAppSpecStaticSiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecStaticSite | undefined;
    set internalValue(value: DataDigitaloceanAppSpecStaticSite | undefined);
    get buildCommand(): string;
    get catchallDocument(): string;
    private _cors;
    get cors(): DataDigitaloceanAppSpecStaticSiteCorsList;
    get dockerfilePath(): string;
    private _env;
    get env(): DataDigitaloceanAppSpecStaticSiteEnvList;
    get environmentSlug(): string;
    get errorDocument(): string;
    private _git;
    get git(): DataDigitaloceanAppSpecStaticSiteGitList;
    private _github;
    get github(): DataDigitaloceanAppSpecStaticSiteGithubList;
    private _gitlab;
    get gitlab(): DataDigitaloceanAppSpecStaticSiteGitlabList;
    get indexDocument(): string;
    get name(): string;
    get outputDir(): string;
    private _routes;
    get routes(): DataDigitaloceanAppSpecStaticSiteRoutesList;
    get sourceDir(): string;
}
export declare class DataDigitaloceanAppSpecStaticSiteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecStaticSiteOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerAlert {
}
export declare function dataDigitaloceanAppSpecWorkerAlertToTerraform(struct?: DataDigitaloceanAppSpecWorkerAlert): any;
export declare class DataDigitaloceanAppSpecWorkerAlertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerAlert | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerAlert | undefined);
    get disabled(): cdktf.IResolvable;
    get operator(): string;
    get rule(): string;
    get value(): number;
    get window(): string;
}
export declare class DataDigitaloceanAppSpecWorkerAlertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerAlertOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerEnv {
}
export declare function dataDigitaloceanAppSpecWorkerEnvToTerraform(struct?: DataDigitaloceanAppSpecWorkerEnv): any;
export declare class DataDigitaloceanAppSpecWorkerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerEnv | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerEnv | undefined);
    get key(): string;
    get scope(): string;
    get type(): string;
    get value(): string;
}
export declare class DataDigitaloceanAppSpecWorkerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerEnvOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerGit {
}
export declare function dataDigitaloceanAppSpecWorkerGitToTerraform(struct?: DataDigitaloceanAppSpecWorkerGit): any;
export declare class DataDigitaloceanAppSpecWorkerGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerGit | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerGit | undefined);
    get branch(): string;
    get repoCloneUrl(): string;
}
export declare class DataDigitaloceanAppSpecWorkerGitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerGitOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerGithub {
}
export declare function dataDigitaloceanAppSpecWorkerGithubToTerraform(struct?: DataDigitaloceanAppSpecWorkerGithub): any;
export declare class DataDigitaloceanAppSpecWorkerGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerGithub | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerGithub | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecWorkerGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerGithubOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerGitlab {
}
export declare function dataDigitaloceanAppSpecWorkerGitlabToTerraform(struct?: DataDigitaloceanAppSpecWorkerGitlab): any;
export declare class DataDigitaloceanAppSpecWorkerGitlabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerGitlab | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerGitlab | undefined);
    get branch(): string;
    get deployOnPush(): cdktf.IResolvable;
    get repo(): string;
}
export declare class DataDigitaloceanAppSpecWorkerGitlabList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerGitlabOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerImage {
}
export declare function dataDigitaloceanAppSpecWorkerImageToTerraform(struct?: DataDigitaloceanAppSpecWorkerImage): any;
export declare class DataDigitaloceanAppSpecWorkerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerImage | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerImage | undefined);
    get registry(): string;
    get registryType(): string;
    get repository(): string;
    get tag(): string;
}
export declare class DataDigitaloceanAppSpecWorkerImageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerImageOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerLogDestinationDatadog {
}
export declare function dataDigitaloceanAppSpecWorkerLogDestinationDatadogToTerraform(struct?: DataDigitaloceanAppSpecWorkerLogDestinationDatadog): any;
export declare class DataDigitaloceanAppSpecWorkerLogDestinationDatadogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerLogDestinationDatadog | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerLogDestinationDatadog | undefined);
    get apiKey(): string;
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecWorkerLogDestinationDatadogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerLogDestinationDatadogOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerLogDestinationLogtail {
}
export declare function dataDigitaloceanAppSpecWorkerLogDestinationLogtailToTerraform(struct?: DataDigitaloceanAppSpecWorkerLogDestinationLogtail): any;
export declare class DataDigitaloceanAppSpecWorkerLogDestinationLogtailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerLogDestinationLogtail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerLogDestinationLogtail | undefined);
    get token(): string;
}
export declare class DataDigitaloceanAppSpecWorkerLogDestinationLogtailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerLogDestinationLogtailOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerLogDestinationPapertrail {
}
export declare function dataDigitaloceanAppSpecWorkerLogDestinationPapertrailToTerraform(struct?: DataDigitaloceanAppSpecWorkerLogDestinationPapertrail): any;
export declare class DataDigitaloceanAppSpecWorkerLogDestinationPapertrailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerLogDestinationPapertrail | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerLogDestinationPapertrail | undefined);
    get endpoint(): string;
}
export declare class DataDigitaloceanAppSpecWorkerLogDestinationPapertrailList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerLogDestinationPapertrailOutputReference;
}
export interface DataDigitaloceanAppSpecWorkerLogDestination {
}
export declare function dataDigitaloceanAppSpecWorkerLogDestinationToTerraform(struct?: DataDigitaloceanAppSpecWorkerLogDestination): any;
export declare class DataDigitaloceanAppSpecWorkerLogDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorkerLogDestination | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorkerLogDestination | undefined);
    private _datadog;
    get datadog(): DataDigitaloceanAppSpecWorkerLogDestinationDatadogList;
    private _logtail;
    get logtail(): DataDigitaloceanAppSpecWorkerLogDestinationLogtailList;
    get name(): string;
    private _papertrail;
    get papertrail(): DataDigitaloceanAppSpecWorkerLogDestinationPapertrailList;
}
export declare class DataDigitaloceanAppSpecWorkerLogDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerLogDestinationOutputReference;
}
export interface DataDigitaloceanAppSpecWorker {
}
export declare function dataDigitaloceanAppSpecWorkerToTerraform(struct?: DataDigitaloceanAppSpecWorker): any;
export declare class DataDigitaloceanAppSpecWorkerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpecWorker | undefined;
    set internalValue(value: DataDigitaloceanAppSpecWorker | undefined);
    private _alert;
    get alert(): DataDigitaloceanAppSpecWorkerAlertList;
    get buildCommand(): string;
    get dockerfilePath(): string;
    private _env;
    get env(): DataDigitaloceanAppSpecWorkerEnvList;
    get environmentSlug(): string;
    private _git;
    get git(): DataDigitaloceanAppSpecWorkerGitList;
    private _github;
    get github(): DataDigitaloceanAppSpecWorkerGithubList;
    private _gitlab;
    get gitlab(): DataDigitaloceanAppSpecWorkerGitlabList;
    private _image;
    get image(): DataDigitaloceanAppSpecWorkerImageList;
    get instanceCount(): number;
    get instanceSizeSlug(): string;
    private _logDestination;
    get logDestination(): DataDigitaloceanAppSpecWorkerLogDestinationList;
    get name(): string;
    get runCommand(): string;
    get sourceDir(): string;
}
export declare class DataDigitaloceanAppSpecWorkerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecWorkerOutputReference;
}
export interface DataDigitaloceanAppSpec {
}
export declare function dataDigitaloceanAppSpecToTerraform(struct?: DataDigitaloceanAppSpec): any;
export declare class DataDigitaloceanAppSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanAppSpec | undefined;
    set internalValue(value: DataDigitaloceanAppSpec | undefined);
    private _alert;
    get alert(): DataDigitaloceanAppSpecAlertList;
    private _database;
    get database(): DataDigitaloceanAppSpecDatabaseList;
    private _domain;
    get domain(): DataDigitaloceanAppSpecDomainList;
    get domains(): string[];
    private _env;
    get env(): DataDigitaloceanAppSpecEnvList;
    private _function;
    get function(): DataDigitaloceanAppSpecFunctionList;
    private _job;
    get job(): DataDigitaloceanAppSpecJobList;
    get name(): string;
    get region(): string;
    private _service;
    get service(): DataDigitaloceanAppSpecServiceList;
    private _staticSite;
    get staticSite(): DataDigitaloceanAppSpecStaticSiteList;
    private _worker;
    get worker(): DataDigitaloceanAppSpecWorkerList;
}
export declare class DataDigitaloceanAppSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanAppSpecOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/app digitalocean_app}
*/
export declare class DataDigitaloceanApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/app digitalocean_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanAppConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanAppConfig);
    get activeDeploymentId(): string;
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get createdAt(): string;
    get defaultIngress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get liveUrl(): string;
    private _spec;
    get spec(): DataDigitaloceanAppSpecList;
    get updatedAt(): string;
    get urn(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
