import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/container_registry#id DataDigitaloceanContainerRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * name of the container registry
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/container_registry#name DataDigitaloceanContainerRegistry#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/container_registry digitalocean_container_registry}
*/
export declare class DataDigitaloceanContainerRegistry extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_container_registry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/container_registry digitalocean_container_registry} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanContainerRegistryConfig);
    get createdAt(): string;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get region(): string;
    get serverUrl(): string;
    get storageUsageBytes(): number;
    get subscriptionTierSlug(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
