import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanDatabaseCaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_ca#cluster_id DataDigitaloceanDatabaseCa#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_ca#id DataDigitaloceanDatabaseCa#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/database_ca digitalocean_database_ca}
*/
export declare class DataDigitaloceanDatabaseCa extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_database_ca";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/database_ca digitalocean_database_ca} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanDatabaseCaConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanDatabaseCaConfig);
    get certificate(): string;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
