import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanDatabaseClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_cluster#id DataDigitaloceanDatabaseCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_cluster#name DataDigitaloceanDatabaseCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_cluster#tags DataDigitaloceanDatabaseCluster#tags}
    */
    readonly tags?: string[];
}
export interface DataDigitaloceanDatabaseClusterMaintenanceWindow {
}
export declare function dataDigitaloceanDatabaseClusterMaintenanceWindowToTerraform(struct?: DataDigitaloceanDatabaseClusterMaintenanceWindow): any;
export declare class DataDigitaloceanDatabaseClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanDatabaseClusterMaintenanceWindow | undefined;
    set internalValue(value: DataDigitaloceanDatabaseClusterMaintenanceWindow | undefined);
    get day(): string;
    get hour(): string;
}
export declare class DataDigitaloceanDatabaseClusterMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanDatabaseClusterMaintenanceWindowOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/database_cluster digitalocean_database_cluster}
*/
export declare class DataDigitaloceanDatabaseCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_database_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/database_cluster digitalocean_database_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanDatabaseClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanDatabaseClusterConfig);
    get database(): string;
    get engine(): string;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): DataDigitaloceanDatabaseClusterMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nodeCount(): number;
    get password(): string;
    get port(): number;
    get privateHost(): string;
    get privateNetworkUuid(): string;
    get privateUri(): string;
    get region(): string;
    get size(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uri(): string;
    get urn(): string;
    get user(): string;
    get version(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
