import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanDatabaseReplicaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_replica#cluster_id DataDigitaloceanDatabaseReplica#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_replica#id DataDigitaloceanDatabaseReplica#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_replica#name DataDigitaloceanDatabaseReplica#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/database_replica#tags DataDigitaloceanDatabaseReplica#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/database_replica digitalocean_database_replica}
*/
export declare class DataDigitaloceanDatabaseReplica extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_database_replica";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/database_replica digitalocean_database_replica} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanDatabaseReplicaConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanDatabaseReplicaConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get database(): string;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get password(): string;
    get port(): number;
    get privateHost(): string;
    get privateNetworkUuid(): string;
    get privateUri(): string;
    get region(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uri(): string;
    get user(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
