import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/domain#id DataDigitaloceanDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * name of the domain
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/domain#name DataDigitaloceanDomain#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/domain digitalocean_domain}
*/
export declare class DataDigitaloceanDomain extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/domain digitalocean_domain} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanDomainConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanDomainConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get ttl(): number;
    get urn(): string;
    get zoneFile(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
