import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanDropletConfig extends cdktf.TerraformMetaArguments {
    /**
    * id of the Droplet
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplet#id DataDigitaloceanDroplet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * name of the Droplet
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplet#name DataDigitaloceanDroplet#name}
    */
    readonly name?: string;
    /**
    * unique tag of the Droplet
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplet#tag DataDigitaloceanDroplet#tag}
    */
    readonly tag?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/droplet digitalocean_droplet}
*/
export declare class DataDigitaloceanDroplet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_droplet";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/droplet digitalocean_droplet} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanDropletConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanDropletConfig);
    get backups(): cdktf.IResolvable;
    get createdAt(): string;
    get disk(): number;
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    get image(): string;
    get ipv4Address(): string;
    get ipv4AddressPrivate(): string;
    get ipv6(): cdktf.IResolvable;
    get ipv6Address(): string;
    get ipv6AddressPrivate(): string;
    get locked(): cdktf.IResolvable;
    get memory(): number;
    get monitoring(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get priceHourly(): number;
    get priceMonthly(): number;
    get privateNetworking(): cdktf.IResolvable;
    get region(): string;
    get size(): string;
    get status(): string;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    get tags(): string[];
    get urn(): string;
    get vcpus(): number;
    get volumeIds(): string[];
    get vpcUuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
