import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanDropletsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#id DataDigitaloceanDroplets#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#filter DataDigitaloceanDroplets#filter}
    */
    readonly filter?: DataDigitaloceanDropletsFilter[] | cdktf.IResolvable;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#sort DataDigitaloceanDroplets#sort}
    */
    readonly sort?: DataDigitaloceanDropletsSort[] | cdktf.IResolvable;
}
export interface DataDigitaloceanDropletsDroplets {
}
export declare function dataDigitaloceanDropletsDropletsToTerraform(struct?: DataDigitaloceanDropletsDroplets): any;
export declare class DataDigitaloceanDropletsDropletsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanDropletsDroplets | undefined;
    set internalValue(value: DataDigitaloceanDropletsDroplets | undefined);
    get backups(): cdktf.IResolvable;
    get createdAt(): string;
    get disk(): number;
    get id(): number;
    get image(): string;
    get ipv4Address(): string;
    get ipv4AddressPrivate(): string;
    get ipv6(): cdktf.IResolvable;
    get ipv6Address(): string;
    get ipv6AddressPrivate(): string;
    get locked(): cdktf.IResolvable;
    get memory(): number;
    get monitoring(): cdktf.IResolvable;
    get name(): string;
    get priceHourly(): number;
    get priceMonthly(): number;
    get privateNetworking(): cdktf.IResolvable;
    get region(): string;
    get size(): string;
    get status(): string;
    get tags(): string[];
    get urn(): string;
    get vcpus(): number;
    get volumeIds(): string[];
    get vpcUuid(): string;
}
export declare class DataDigitaloceanDropletsDropletsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanDropletsDropletsOutputReference;
}
export interface DataDigitaloceanDropletsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#all DataDigitaloceanDroplets#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#key DataDigitaloceanDroplets#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#match_by DataDigitaloceanDroplets#match_by}
    */
    readonly matchBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#values DataDigitaloceanDroplets#values}
    */
    readonly values: string[];
}
export declare function dataDigitaloceanDropletsFilterToTerraform(struct?: DataDigitaloceanDropletsFilter | cdktf.IResolvable): any;
export declare class DataDigitaloceanDropletsFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanDropletsFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanDropletsFilter | cdktf.IResolvable | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _matchBy?;
    get matchBy(): string;
    set matchBy(value: string);
    resetMatchBy(): void;
    get matchByInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataDigitaloceanDropletsFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanDropletsFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanDropletsFilterOutputReference;
}
export interface DataDigitaloceanDropletsSort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#direction DataDigitaloceanDroplets#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets#key DataDigitaloceanDroplets#key}
    */
    readonly key: string;
}
export declare function dataDigitaloceanDropletsSortToTerraform(struct?: DataDigitaloceanDropletsSort | cdktf.IResolvable): any;
export declare class DataDigitaloceanDropletsSortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanDropletsSort | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanDropletsSort | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class DataDigitaloceanDropletsSortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanDropletsSort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanDropletsSortOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets digitalocean_droplets}
*/
export declare class DataDigitaloceanDroplets extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_droplets";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/droplets digitalocean_droplets} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanDropletsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanDropletsConfig);
    private _droplets;
    get droplets(): DataDigitaloceanDropletsDropletsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _filter;
    get filter(): DataDigitaloceanDropletsFilterList;
    putFilter(value: DataDigitaloceanDropletsFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataDigitaloceanDropletsFilter[] | undefined;
    private _sort;
    get sort(): DataDigitaloceanDropletsSortList;
    putSort(value: DataDigitaloceanDropletsSort[] | cdktf.IResolvable): void;
    resetSort(): void;
    get sortInput(): cdktf.IResolvable | DataDigitaloceanDropletsSort[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
