import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#droplet_ids DataDigitaloceanFirewall#droplet_ids}
    */
    readonly dropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#firewall_id DataDigitaloceanFirewall#firewall_id}
    */
    readonly firewallId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#id DataDigitaloceanFirewall#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#tags DataDigitaloceanFirewall#tags}
    */
    readonly tags?: string[];
    /**
    * inbound_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#inbound_rule DataDigitaloceanFirewall#inbound_rule}
    */
    readonly inboundRule?: DataDigitaloceanFirewallInboundRule[] | cdktf.IResolvable;
    /**
    * outbound_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#outbound_rule DataDigitaloceanFirewall#outbound_rule}
    */
    readonly outboundRule?: DataDigitaloceanFirewallOutboundRule[] | cdktf.IResolvable;
}
export interface DataDigitaloceanFirewallPendingChanges {
}
export declare function dataDigitaloceanFirewallPendingChangesToTerraform(struct?: DataDigitaloceanFirewallPendingChanges): any;
export declare class DataDigitaloceanFirewallPendingChangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanFirewallPendingChanges | undefined;
    set internalValue(value: DataDigitaloceanFirewallPendingChanges | undefined);
    get dropletId(): number;
    get removing(): cdktf.IResolvable;
    get status(): string;
}
export declare class DataDigitaloceanFirewallPendingChangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanFirewallPendingChangesOutputReference;
}
export interface DataDigitaloceanFirewallInboundRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#port_range DataDigitaloceanFirewall#port_range}
    */
    readonly portRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#protocol DataDigitaloceanFirewall#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#source_addresses DataDigitaloceanFirewall#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#source_droplet_ids DataDigitaloceanFirewall#source_droplet_ids}
    */
    readonly sourceDropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#source_kubernetes_ids DataDigitaloceanFirewall#source_kubernetes_ids}
    */
    readonly sourceKubernetesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#source_load_balancer_uids DataDigitaloceanFirewall#source_load_balancer_uids}
    */
    readonly sourceLoadBalancerUids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#source_tags DataDigitaloceanFirewall#source_tags}
    */
    readonly sourceTags?: string[];
}
export declare function dataDigitaloceanFirewallInboundRuleToTerraform(struct?: DataDigitaloceanFirewallInboundRule | cdktf.IResolvable): any;
export declare class DataDigitaloceanFirewallInboundRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanFirewallInboundRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanFirewallInboundRule | cdktf.IResolvable | undefined);
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _sourceAddresses?;
    get sourceAddresses(): string[];
    set sourceAddresses(value: string[]);
    resetSourceAddresses(): void;
    get sourceAddressesInput(): string[] | undefined;
    private _sourceDropletIds?;
    get sourceDropletIds(): number[];
    set sourceDropletIds(value: number[]);
    resetSourceDropletIds(): void;
    get sourceDropletIdsInput(): number[] | undefined;
    private _sourceKubernetesIds?;
    get sourceKubernetesIds(): string[];
    set sourceKubernetesIds(value: string[]);
    resetSourceKubernetesIds(): void;
    get sourceKubernetesIdsInput(): string[] | undefined;
    private _sourceLoadBalancerUids?;
    get sourceLoadBalancerUids(): string[];
    set sourceLoadBalancerUids(value: string[]);
    resetSourceLoadBalancerUids(): void;
    get sourceLoadBalancerUidsInput(): string[] | undefined;
    private _sourceTags?;
    get sourceTags(): string[];
    set sourceTags(value: string[]);
    resetSourceTags(): void;
    get sourceTagsInput(): string[] | undefined;
}
export declare class DataDigitaloceanFirewallInboundRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanFirewallInboundRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanFirewallInboundRuleOutputReference;
}
export interface DataDigitaloceanFirewallOutboundRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#destination_addresses DataDigitaloceanFirewall#destination_addresses}
    */
    readonly destinationAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#destination_droplet_ids DataDigitaloceanFirewall#destination_droplet_ids}
    */
    readonly destinationDropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#destination_kubernetes_ids DataDigitaloceanFirewall#destination_kubernetes_ids}
    */
    readonly destinationKubernetesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#destination_load_balancer_uids DataDigitaloceanFirewall#destination_load_balancer_uids}
    */
    readonly destinationLoadBalancerUids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#destination_tags DataDigitaloceanFirewall#destination_tags}
    */
    readonly destinationTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#port_range DataDigitaloceanFirewall#port_range}
    */
    readonly portRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall#protocol DataDigitaloceanFirewall#protocol}
    */
    readonly protocol: string;
}
export declare function dataDigitaloceanFirewallOutboundRuleToTerraform(struct?: DataDigitaloceanFirewallOutboundRule | cdktf.IResolvable): any;
export declare class DataDigitaloceanFirewallOutboundRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanFirewallOutboundRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanFirewallOutboundRule | cdktf.IResolvable | undefined);
    private _destinationAddresses?;
    get destinationAddresses(): string[];
    set destinationAddresses(value: string[]);
    resetDestinationAddresses(): void;
    get destinationAddressesInput(): string[] | undefined;
    private _destinationDropletIds?;
    get destinationDropletIds(): number[];
    set destinationDropletIds(value: number[]);
    resetDestinationDropletIds(): void;
    get destinationDropletIdsInput(): number[] | undefined;
    private _destinationKubernetesIds?;
    get destinationKubernetesIds(): string[];
    set destinationKubernetesIds(value: string[]);
    resetDestinationKubernetesIds(): void;
    get destinationKubernetesIdsInput(): string[] | undefined;
    private _destinationLoadBalancerUids?;
    get destinationLoadBalancerUids(): string[];
    set destinationLoadBalancerUids(value: string[]);
    resetDestinationLoadBalancerUids(): void;
    get destinationLoadBalancerUidsInput(): string[] | undefined;
    private _destinationTags?;
    get destinationTags(): string[];
    set destinationTags(value: string[]);
    resetDestinationTags(): void;
    get destinationTagsInput(): string[] | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class DataDigitaloceanFirewallOutboundRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanFirewallOutboundRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanFirewallOutboundRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall digitalocean_firewall}
*/
export declare class DataDigitaloceanFirewall extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_firewall";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/firewall digitalocean_firewall} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanFirewallConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanFirewallConfig);
    get createdAt(): string;
    private _dropletIds?;
    get dropletIds(): number[];
    set dropletIds(value: number[]);
    resetDropletIds(): void;
    get dropletIdsInput(): number[] | undefined;
    private _firewallId?;
    get firewallId(): string;
    set firewallId(value: string);
    get firewallIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _pendingChanges;
    get pendingChanges(): DataDigitaloceanFirewallPendingChangesList;
    get status(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _inboundRule;
    get inboundRule(): DataDigitaloceanFirewallInboundRuleList;
    putInboundRule(value: DataDigitaloceanFirewallInboundRule[] | cdktf.IResolvable): void;
    resetInboundRule(): void;
    get inboundRuleInput(): cdktf.IResolvable | DataDigitaloceanFirewallInboundRule[] | undefined;
    private _outboundRule;
    get outboundRule(): DataDigitaloceanFirewallOutboundRuleList;
    putOutboundRule(value: DataDigitaloceanFirewallOutboundRule[] | cdktf.IResolvable): void;
    resetOutboundRule(): void;
    get outboundRuleInput(): cdktf.IResolvable | DataDigitaloceanFirewallOutboundRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
