import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanFloatingIpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/floating_ip#id DataDigitaloceanFloatingIp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * floating ip address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/floating_ip#ip_address DataDigitaloceanFloatingIp#ip_address}
    */
    readonly ipAddress: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/floating_ip digitalocean_floating_ip}
*/
export declare class DataDigitaloceanFloatingIp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_floating_ip";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/floating_ip digitalocean_floating_ip} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanFloatingIpConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanFloatingIpConfig);
    get dropletId(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    get region(): string;
    get urn(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
