import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * id of the image
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/image#id DataDigitaloceanImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * name of the image
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/image#name DataDigitaloceanImage#name}
    */
    readonly name?: string;
    /**
    * slug of the image
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/image#slug DataDigitaloceanImage#slug}
    */
    readonly slug?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/image#source DataDigitaloceanImage#source}
    */
    readonly source?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/image digitalocean_image}
*/
export declare class DataDigitaloceanImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/image digitalocean_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanImageConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanImageConfig);
    get created(): string;
    get description(): string;
    get distribution(): string;
    get errorMessage(): string;
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    get image(): string;
    get minDiskSize(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get private(): cdktf.IResolvable;
    get regions(): string[];
    get sizeGigabytes(): number;
    private _slug?;
    get slug(): string;
    set slug(value: string);
    resetSlug(): void;
    get slugInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    get status(): string;
    get tags(): string[];
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
