import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_cluster#id DataDigitaloceanKubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_cluster#name DataDigitaloceanKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_cluster#tags DataDigitaloceanKubernetesCluster#tags}
    */
    readonly tags?: string[];
}
export interface DataDigitaloceanKubernetesClusterKubeConfig {
}
export declare function dataDigitaloceanKubernetesClusterKubeConfigToTerraform(struct?: DataDigitaloceanKubernetesClusterKubeConfig): any;
export declare class DataDigitaloceanKubernetesClusterKubeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanKubernetesClusterKubeConfig | undefined;
    set internalValue(value: DataDigitaloceanKubernetesClusterKubeConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get expiresAt(): string;
    get host(): string;
    get rawConfig(): string;
    get token(): string;
}
export declare class DataDigitaloceanKubernetesClusterKubeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanKubernetesClusterKubeConfigOutputReference;
}
export interface DataDigitaloceanKubernetesClusterMaintenancePolicy {
}
export declare function dataDigitaloceanKubernetesClusterMaintenancePolicyToTerraform(struct?: DataDigitaloceanKubernetesClusterMaintenancePolicy): any;
export declare class DataDigitaloceanKubernetesClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanKubernetesClusterMaintenancePolicy | undefined;
    set internalValue(value: DataDigitaloceanKubernetesClusterMaintenancePolicy | undefined);
    get day(): string;
    get duration(): string;
    get startTime(): string;
}
export declare class DataDigitaloceanKubernetesClusterMaintenancePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanKubernetesClusterMaintenancePolicyOutputReference;
}
export interface DataDigitaloceanKubernetesClusterNodePoolNodes {
}
export declare function dataDigitaloceanKubernetesClusterNodePoolNodesToTerraform(struct?: DataDigitaloceanKubernetesClusterNodePoolNodes): any;
export declare class DataDigitaloceanKubernetesClusterNodePoolNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanKubernetesClusterNodePoolNodes | undefined;
    set internalValue(value: DataDigitaloceanKubernetesClusterNodePoolNodes | undefined);
    get createdAt(): string;
    get dropletId(): string;
    get id(): string;
    get name(): string;
    get status(): string;
    get updatedAt(): string;
}
export declare class DataDigitaloceanKubernetesClusterNodePoolNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanKubernetesClusterNodePoolNodesOutputReference;
}
export interface DataDigitaloceanKubernetesClusterNodePoolTaint {
}
export declare function dataDigitaloceanKubernetesClusterNodePoolTaintToTerraform(struct?: DataDigitaloceanKubernetesClusterNodePoolTaint): any;
export declare class DataDigitaloceanKubernetesClusterNodePoolTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanKubernetesClusterNodePoolTaint | undefined;
    set internalValue(value: DataDigitaloceanKubernetesClusterNodePoolTaint | undefined);
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataDigitaloceanKubernetesClusterNodePoolTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanKubernetesClusterNodePoolTaintOutputReference;
}
export interface DataDigitaloceanKubernetesClusterNodePool {
}
export declare function dataDigitaloceanKubernetesClusterNodePoolToTerraform(struct?: DataDigitaloceanKubernetesClusterNodePool): any;
export declare class DataDigitaloceanKubernetesClusterNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanKubernetesClusterNodePool | undefined;
    set internalValue(value: DataDigitaloceanKubernetesClusterNodePool | undefined);
    get actualNodeCount(): number;
    get autoScale(): cdktf.IResolvable;
    get id(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get maxNodes(): number;
    get minNodes(): number;
    get name(): string;
    get nodeCount(): number;
    private _nodes;
    get nodes(): DataDigitaloceanKubernetesClusterNodePoolNodesList;
    get size(): string;
    get tags(): string[];
    private _taint;
    get taint(): DataDigitaloceanKubernetesClusterNodePoolTaintList;
}
export declare class DataDigitaloceanKubernetesClusterNodePoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanKubernetesClusterNodePoolOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_cluster digitalocean_kubernetes_cluster}
*/
export declare class DataDigitaloceanKubernetesCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_kubernetes_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_cluster digitalocean_kubernetes_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanKubernetesClusterConfig);
    get autoUpgrade(): cdktf.IResolvable;
    get clusterSubnet(): string;
    get createdAt(): string;
    get endpoint(): string;
    get ha(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipv4Address(): string;
    private _kubeConfig;
    get kubeConfig(): DataDigitaloceanKubernetesClusterKubeConfigList;
    private _maintenancePolicy;
    get maintenancePolicy(): DataDigitaloceanKubernetesClusterMaintenancePolicyList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodePool;
    get nodePool(): DataDigitaloceanKubernetesClusterNodePoolList;
    get region(): string;
    get serviceSubnet(): string;
    get status(): string;
    get surgeUpgrade(): cdktf.IResolvable;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get updatedAt(): string;
    get urn(): string;
    get version(): string;
    get vpcUuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
