import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanKubernetesVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_versions#id DataDigitaloceanKubernetesVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_versions#version_prefix DataDigitaloceanKubernetesVersions#version_prefix}
    */
    readonly versionPrefix?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_versions digitalocean_kubernetes_versions}
*/
export declare class DataDigitaloceanKubernetesVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_kubernetes_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/kubernetes_versions digitalocean_kubernetes_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanKubernetesVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanKubernetesVersionsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get latestVersion(): string;
    get validVersions(): string[];
    private _versionPrefix?;
    get versionPrefix(): string;
    set versionPrefix(value: string);
    resetVersionPrefix(): void;
    get versionPrefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
