import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanLoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * id of the load balancer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/loadbalancer#id DataDigitaloceanLoadbalancer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * name of the load balancer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/loadbalancer#name DataDigitaloceanLoadbalancer#name}
    */
    readonly name?: string;
}
export interface DataDigitaloceanLoadbalancerForwardingRule {
}
export declare function dataDigitaloceanLoadbalancerForwardingRuleToTerraform(struct?: DataDigitaloceanLoadbalancerForwardingRule): any;
export declare class DataDigitaloceanLoadbalancerForwardingRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanLoadbalancerForwardingRule | undefined;
    set internalValue(value: DataDigitaloceanLoadbalancerForwardingRule | undefined);
    get certificateId(): string;
    get certificateName(): string;
    get entryPort(): number;
    get entryProtocol(): string;
    get targetPort(): number;
    get targetProtocol(): string;
    get tlsPassthrough(): cdktf.IResolvable;
}
export declare class DataDigitaloceanLoadbalancerForwardingRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanLoadbalancerForwardingRuleOutputReference;
}
export interface DataDigitaloceanLoadbalancerHealthcheck {
}
export declare function dataDigitaloceanLoadbalancerHealthcheckToTerraform(struct?: DataDigitaloceanLoadbalancerHealthcheck): any;
export declare class DataDigitaloceanLoadbalancerHealthcheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanLoadbalancerHealthcheck | undefined;
    set internalValue(value: DataDigitaloceanLoadbalancerHealthcheck | undefined);
    get checkIntervalSeconds(): number;
    get healthyThreshold(): number;
    get path(): string;
    get port(): number;
    get protocol(): string;
    get responseTimeoutSeconds(): number;
    get unhealthyThreshold(): number;
}
export declare class DataDigitaloceanLoadbalancerHealthcheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanLoadbalancerHealthcheckOutputReference;
}
export interface DataDigitaloceanLoadbalancerStickySessions {
}
export declare function dataDigitaloceanLoadbalancerStickySessionsToTerraform(struct?: DataDigitaloceanLoadbalancerStickySessions): any;
export declare class DataDigitaloceanLoadbalancerStickySessionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanLoadbalancerStickySessions | undefined;
    set internalValue(value: DataDigitaloceanLoadbalancerStickySessions | undefined);
    get cookieName(): string;
    get cookieTtlSeconds(): number;
    get type(): string;
}
export declare class DataDigitaloceanLoadbalancerStickySessionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanLoadbalancerStickySessionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/loadbalancer digitalocean_loadbalancer}
*/
export declare class DataDigitaloceanLoadbalancer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_loadbalancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/loadbalancer digitalocean_loadbalancer} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanLoadbalancerConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanLoadbalancerConfig);
    get algorithm(): string;
    get disableLetsEncryptDnsRecords(): cdktf.IResolvable;
    get dropletIds(): number[];
    get dropletTag(): string;
    get enableBackendKeepalive(): cdktf.IResolvable;
    get enableProxyProtocol(): cdktf.IResolvable;
    private _forwardingRule;
    get forwardingRule(): DataDigitaloceanLoadbalancerForwardingRuleList;
    private _healthcheck;
    get healthcheck(): DataDigitaloceanLoadbalancerHealthcheckList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ip(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get redirectHttpToHttps(): cdktf.IResolvable;
    get region(): string;
    get size(): string;
    get sizeUnit(): number;
    get status(): string;
    private _stickySessions;
    get stickySessions(): DataDigitaloceanLoadbalancerStickySessionsList;
    get urn(): string;
    get vpcUuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
