import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/project#id DataDigitaloceanProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/project#name DataDigitaloceanProject#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/project digitalocean_project}
*/
export declare class DataDigitaloceanProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/project digitalocean_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanProjectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanProjectConfig);
    get createdAt(): string;
    get description(): string;
    get environment(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isDefault(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get ownerId(): number;
    get ownerUuid(): string;
    get purpose(): string;
    get resources(): string[];
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
