import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanProjectsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#id DataDigitaloceanProjects#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#filter DataDigitaloceanProjects#filter}
    */
    readonly filter?: DataDigitaloceanProjectsFilter[] | cdktf.IResolvable;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#sort DataDigitaloceanProjects#sort}
    */
    readonly sort?: DataDigitaloceanProjectsSort[] | cdktf.IResolvable;
}
export interface DataDigitaloceanProjectsProjects {
}
export declare function dataDigitaloceanProjectsProjectsToTerraform(struct?: DataDigitaloceanProjectsProjects): any;
export declare class DataDigitaloceanProjectsProjectsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanProjectsProjects | undefined;
    set internalValue(value: DataDigitaloceanProjectsProjects | undefined);
    get createdAt(): string;
    get description(): string;
    get environment(): string;
    get id(): string;
    get isDefault(): cdktf.IResolvable;
    get name(): string;
    get ownerId(): number;
    get ownerUuid(): string;
    get purpose(): string;
    get resources(): string[];
    get updatedAt(): string;
}
export declare class DataDigitaloceanProjectsProjectsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanProjectsProjectsOutputReference;
}
export interface DataDigitaloceanProjectsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#all DataDigitaloceanProjects#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#key DataDigitaloceanProjects#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#match_by DataDigitaloceanProjects#match_by}
    */
    readonly matchBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#values DataDigitaloceanProjects#values}
    */
    readonly values: string[];
}
export declare function dataDigitaloceanProjectsFilterToTerraform(struct?: DataDigitaloceanProjectsFilter | cdktf.IResolvable): any;
export declare class DataDigitaloceanProjectsFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanProjectsFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanProjectsFilter | cdktf.IResolvable | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _matchBy?;
    get matchBy(): string;
    set matchBy(value: string);
    resetMatchBy(): void;
    get matchByInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataDigitaloceanProjectsFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanProjectsFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanProjectsFilterOutputReference;
}
export interface DataDigitaloceanProjectsSort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#direction DataDigitaloceanProjects#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/projects#key DataDigitaloceanProjects#key}
    */
    readonly key: string;
}
export declare function dataDigitaloceanProjectsSortToTerraform(struct?: DataDigitaloceanProjectsSort | cdktf.IResolvable): any;
export declare class DataDigitaloceanProjectsSortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanProjectsSort | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanProjectsSort | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class DataDigitaloceanProjectsSortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanProjectsSort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanProjectsSortOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/projects digitalocean_projects}
*/
export declare class DataDigitaloceanProjects extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_projects";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/projects digitalocean_projects} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanProjectsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanProjectsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projects;
    get projects(): DataDigitaloceanProjectsProjectsList;
    private _filter;
    get filter(): DataDigitaloceanProjectsFilterList;
    putFilter(value: DataDigitaloceanProjectsFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataDigitaloceanProjectsFilter[] | undefined;
    private _sort;
    get sort(): DataDigitaloceanProjectsSortList;
    putSort(value: DataDigitaloceanProjectsSort[] | cdktf.IResolvable): void;
    resetSort(): void;
    get sortInput(): cdktf.IResolvable | DataDigitaloceanProjectsSort[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
