import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * domain of the name record
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/record#domain DataDigitaloceanRecord#domain}
    */
    readonly domain: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/record#id DataDigitaloceanRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * name of the record
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/record#name DataDigitaloceanRecord#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/record digitalocean_record}
*/
export declare class DataDigitaloceanRecord extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_record";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/record digitalocean_record} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanRecordConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanRecordConfig);
    get data(): string;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    get flags(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get port(): number;
    get priority(): number;
    get tag(): string;
    get ttl(): number;
    get type(): string;
    get weight(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
