import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanRegionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/region#id DataDigitaloceanRegion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/region#slug DataDigitaloceanRegion#slug}
    */
    readonly slug: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/region digitalocean_region}
*/
export declare class DataDigitaloceanRegion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_region";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/region digitalocean_region} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanRegionConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanRegionConfig);
    get available(): cdktf.IResolvable;
    get features(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get sizes(): string[];
    private _slug?;
    get slug(): string;
    set slug(value: string);
    get slugInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
