import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanSizesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#id DataDigitaloceanSizes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#filter DataDigitaloceanSizes#filter}
    */
    readonly filter?: DataDigitaloceanSizesFilter[] | cdktf.IResolvable;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#sort DataDigitaloceanSizes#sort}
    */
    readonly sort?: DataDigitaloceanSizesSort[] | cdktf.IResolvable;
}
export interface DataDigitaloceanSizesSizes {
}
export declare function dataDigitaloceanSizesSizesToTerraform(struct?: DataDigitaloceanSizesSizes): any;
export declare class DataDigitaloceanSizesSizesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanSizesSizes | undefined;
    set internalValue(value: DataDigitaloceanSizesSizes | undefined);
    get available(): cdktf.IResolvable;
    get disk(): number;
    get memory(): number;
    get priceHourly(): number;
    get priceMonthly(): number;
    get regions(): string[];
    get slug(): string;
    get transfer(): number;
    get vcpus(): number;
}
export declare class DataDigitaloceanSizesSizesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanSizesSizesOutputReference;
}
export interface DataDigitaloceanSizesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#all DataDigitaloceanSizes#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#key DataDigitaloceanSizes#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#match_by DataDigitaloceanSizes#match_by}
    */
    readonly matchBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#values DataDigitaloceanSizes#values}
    */
    readonly values: string[];
}
export declare function dataDigitaloceanSizesFilterToTerraform(struct?: DataDigitaloceanSizesFilter | cdktf.IResolvable): any;
export declare class DataDigitaloceanSizesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanSizesFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanSizesFilter | cdktf.IResolvable | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _matchBy?;
    get matchBy(): string;
    set matchBy(value: string);
    resetMatchBy(): void;
    get matchByInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataDigitaloceanSizesFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanSizesFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanSizesFilterOutputReference;
}
export interface DataDigitaloceanSizesSort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#direction DataDigitaloceanSizes#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes#key DataDigitaloceanSizes#key}
    */
    readonly key: string;
}
export declare function dataDigitaloceanSizesSortToTerraform(struct?: DataDigitaloceanSizesSort | cdktf.IResolvable): any;
export declare class DataDigitaloceanSizesSortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanSizesSort | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanSizesSort | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class DataDigitaloceanSizesSortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanSizesSort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanSizesSortOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes digitalocean_sizes}
*/
export declare class DataDigitaloceanSizes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_sizes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/sizes digitalocean_sizes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanSizesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanSizesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sizes;
    get sizes(): DataDigitaloceanSizesSizesList;
    private _filter;
    get filter(): DataDigitaloceanSizesFilterList;
    putFilter(value: DataDigitaloceanSizesFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataDigitaloceanSizesFilter[] | undefined;
    private _sort;
    get sort(): DataDigitaloceanSizesSortList;
    putSort(value: DataDigitaloceanSizesSort[] | cdktf.IResolvable): void;
    resetSort(): void;
    get sortInput(): cdktf.IResolvable | DataDigitaloceanSizesSort[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
