import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanSshKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * name of the ssh key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/ssh_key#name DataDigitaloceanSshKey#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/ssh_key digitalocean_ssh_key}
*/
export declare class DataDigitaloceanSshKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_ssh_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/ssh_key digitalocean_ssh_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanSshKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanSshKeyConfig);
    get fingerprint(): string;
    get id(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicKey(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
