import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#id DataDigitaloceanTags#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#filter DataDigitaloceanTags#filter}
    */
    readonly filter?: DataDigitaloceanTagsFilter[] | cdktf.IResolvable;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#sort DataDigitaloceanTags#sort}
    */
    readonly sort?: DataDigitaloceanTagsSort[] | cdktf.IResolvable;
}
export interface DataDigitaloceanTagsTags {
}
export declare function dataDigitaloceanTagsTagsToTerraform(struct?: DataDigitaloceanTagsTags): any;
export declare class DataDigitaloceanTagsTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanTagsTags | undefined;
    set internalValue(value: DataDigitaloceanTagsTags | undefined);
    get databasesCount(): number;
    get dropletsCount(): number;
    get imagesCount(): number;
    get name(): string;
    get totalResourceCount(): number;
    get volumeSnapshotsCount(): number;
    get volumesCount(): number;
}
export declare class DataDigitaloceanTagsTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanTagsTagsOutputReference;
}
export interface DataDigitaloceanTagsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#all DataDigitaloceanTags#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#key DataDigitaloceanTags#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#match_by DataDigitaloceanTags#match_by}
    */
    readonly matchBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#values DataDigitaloceanTags#values}
    */
    readonly values: string[];
}
export declare function dataDigitaloceanTagsFilterToTerraform(struct?: DataDigitaloceanTagsFilter | cdktf.IResolvable): any;
export declare class DataDigitaloceanTagsFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanTagsFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanTagsFilter | cdktf.IResolvable | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _matchBy?;
    get matchBy(): string;
    set matchBy(value: string);
    resetMatchBy(): void;
    get matchByInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataDigitaloceanTagsFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanTagsFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanTagsFilterOutputReference;
}
export interface DataDigitaloceanTagsSort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#direction DataDigitaloceanTags#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/tags#key DataDigitaloceanTags#key}
    */
    readonly key: string;
}
export declare function dataDigitaloceanTagsSortToTerraform(struct?: DataDigitaloceanTagsSort | cdktf.IResolvable): any;
export declare class DataDigitaloceanTagsSortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDigitaloceanTagsSort | cdktf.IResolvable | undefined;
    set internalValue(value: DataDigitaloceanTagsSort | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class DataDigitaloceanTagsSortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataDigitaloceanTagsSort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDigitaloceanTagsSortOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/tags digitalocean_tags}
*/
export declare class DataDigitaloceanTags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_tags";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/tags digitalocean_tags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanTagsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanTagsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _tags;
    get tags(): DataDigitaloceanTagsTagsList;
    private _filter;
    get filter(): DataDigitaloceanTagsFilterList;
    putFilter(value: DataDigitaloceanTagsFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataDigitaloceanTagsFilter[] | undefined;
    private _sort;
    get sort(): DataDigitaloceanTagsSortList;
    putSort(value: DataDigitaloceanTagsSort[] | cdktf.IResolvable): void;
    resetSort(): void;
    get sortInput(): cdktf.IResolvable | DataDigitaloceanTagsSort[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
