import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanVolumeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot#id DataDigitaloceanVolumeSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot#most_recent DataDigitaloceanVolumeSnapshot#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot#name DataDigitaloceanVolumeSnapshot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot#name_regex DataDigitaloceanVolumeSnapshot#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot#region DataDigitaloceanVolumeSnapshot#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot digitalocean_volume_snapshot}
*/
export declare class DataDigitaloceanVolumeSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_volume_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/volume_snapshot digitalocean_volume_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanVolumeSnapshotConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanVolumeSnapshotConfig);
    get createdAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get minDiskSize(): number;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get regions(): string[];
    get size(): number;
    get tags(): string[];
    get volumeId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
