import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * volume description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume#description DataDigitaloceanVolume#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume#id DataDigitaloceanVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * name of the volume
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume#name DataDigitaloceanVolume#name}
    */
    readonly name: string;
    /**
    * the region that the volume is provisioned in
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/volume#region DataDigitaloceanVolume#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/volume digitalocean_volume}
*/
export declare class DataDigitaloceanVolume extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_volume";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/volume digitalocean_volume} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanVolumeConfig
    */
    constructor(scope: Construct, id: string, config: DataDigitaloceanVolumeConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get dropletIds(): number[];
    get filesystemLabel(): string;
    get filesystemType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get size(): number;
    get tags(): string[];
    get urn(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
