import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDigitaloceanVpcConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/vpc#id DataDigitaloceanVpc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/vpc#name DataDigitaloceanVpc#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/d/vpc#region DataDigitaloceanVpc#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/d/vpc digitalocean_vpc}
*/
export declare class DataDigitaloceanVpc extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "digitalocean_vpc";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/d/vpc digitalocean_vpc} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDigitaloceanVpcConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDigitaloceanVpcConfig);
    get createdAt(): string;
    get default(): cdktf.IResolvable;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipRange(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get urn(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
