import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#engine DatabaseCluster#engine}
    */
    readonly engine: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#eviction_policy DatabaseCluster#eviction_policy}
    */
    readonly evictionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#id DatabaseCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#name DatabaseCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#node_count DatabaseCluster#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#private_network_uuid DatabaseCluster#private_network_uuid}
    */
    readonly privateNetworkUuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#region DatabaseCluster#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#size DatabaseCluster#size}
    */
    readonly size: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#sql_mode DatabaseCluster#sql_mode}
    */
    readonly sqlMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#tags DatabaseCluster#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#version DatabaseCluster#version}
    */
    readonly version?: string;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#maintenance_window DatabaseCluster#maintenance_window}
    */
    readonly maintenanceWindow?: DatabaseClusterMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#timeouts DatabaseCluster#timeouts}
    */
    readonly timeouts?: DatabaseClusterTimeouts;
}
export interface DatabaseClusterMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#day DatabaseCluster#day}
    */
    readonly day: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#hour DatabaseCluster#hour}
    */
    readonly hour: string;
}
export declare function databaseClusterMaintenanceWindowToTerraform(struct?: DatabaseClusterMaintenanceWindow | cdktf.IResolvable): any;
export declare class DatabaseClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseClusterMaintenanceWindow | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseClusterMaintenanceWindow | cdktf.IResolvable | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _hour?;
    get hour(): string;
    set hour(value: string);
    get hourInput(): string | undefined;
}
export declare class DatabaseClusterMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseClusterMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseClusterMaintenanceWindowOutputReference;
}
export interface DatabaseClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster#create DatabaseCluster#create}
    */
    readonly create?: string;
}
export declare function databaseClusterTimeoutsToTerraform(struct?: DatabaseClusterTimeoutsOutputReference | DatabaseClusterTimeouts | cdktf.IResolvable): any;
export declare class DatabaseClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabaseClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster digitalocean_database_cluster}
*/
export declare class DatabaseCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_database_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/database_cluster digitalocean_database_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseClusterConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseClusterConfig);
    get database(): string;
    private _engine?;
    get engine(): string;
    set engine(value: string);
    get engineInput(): string | undefined;
    private _evictionPolicy?;
    get evictionPolicy(): string;
    set evictionPolicy(value: string);
    resetEvictionPolicy(): void;
    get evictionPolicyInput(): string | undefined;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    get password(): string;
    get port(): number;
    get privateHost(): string;
    private _privateNetworkUuid?;
    get privateNetworkUuid(): string;
    set privateNetworkUuid(value: string);
    resetPrivateNetworkUuid(): void;
    get privateNetworkUuidInput(): string | undefined;
    get privateUri(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    get sizeInput(): string | undefined;
    private _sqlMode?;
    get sqlMode(): string;
    set sqlMode(value: string);
    resetSqlMode(): void;
    get sqlModeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uri(): string;
    get urn(): string;
    get user(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): DatabaseClusterMaintenanceWindowList;
    putMaintenanceWindow(value: DatabaseClusterMaintenanceWindow[] | cdktf.IResolvable): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): cdktf.IResolvable | DatabaseClusterMaintenanceWindow[] | undefined;
    private _timeouts;
    get timeouts(): DatabaseClusterTimeoutsOutputReference;
    putTimeouts(value: DatabaseClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabaseClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
