import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseReplicaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#cluster_id DatabaseReplica#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#id DatabaseReplica#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#name DatabaseReplica#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#private_network_uuid DatabaseReplica#private_network_uuid}
    */
    readonly privateNetworkUuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#region DatabaseReplica#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#size DatabaseReplica#size}
    */
    readonly size?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica#tags DatabaseReplica#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica digitalocean_database_replica}
*/
export declare class DatabaseReplica extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_database_replica";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/database_replica digitalocean_database_replica} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseReplicaConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseReplicaConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get database(): string;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get password(): string;
    get port(): number;
    get privateHost(): string;
    private _privateNetworkUuid?;
    get privateNetworkUuid(): string;
    set privateNetworkUuid(value: string);
    resetPrivateNetworkUuid(): void;
    get privateNetworkUuidInput(): string | undefined;
    get privateUri(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    resetSize(): void;
    get sizeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uri(): string;
    get user(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
