import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_user#cluster_id DatabaseUser#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_user#id DatabaseUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_user#mysql_auth_plugin DatabaseUser#mysql_auth_plugin}
    */
    readonly mysqlAuthPlugin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/database_user#name DatabaseUser#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/database_user digitalocean_database_user}
*/
export declare class DatabaseUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_database_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/database_user digitalocean_database_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseUserConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseUserConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mysqlAuthPlugin?;
    get mysqlAuthPlugin(): string;
    set mysqlAuthPlugin(value: string);
    resetMysqlAuthPlugin(): void;
    get mysqlAuthPluginInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get password(): string;
    get role(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
