import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DigitaloceanProviderConfig {
    /**
    * The URL to use for the DigitalOcean API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean#api_endpoint DigitaloceanProvider#api_endpoint}
    */
    readonly apiEndpoint?: string;
    /**
    * The access key ID for Spaces API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean#spaces_access_id DigitaloceanProvider#spaces_access_id}
    */
    readonly spacesAccessId?: string;
    /**
    * The URL to use for the DigitalOcean Spaces API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean#spaces_endpoint DigitaloceanProvider#spaces_endpoint}
    */
    readonly spacesEndpoint?: string;
    /**
    * The secret access key for Spaces API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean#spaces_secret_key DigitaloceanProvider#spaces_secret_key}
    */
    readonly spacesSecretKey?: string;
    /**
    * The token key for API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean#token DigitaloceanProvider#token}
    */
    readonly token?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean#alias DigitaloceanProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean digitalocean}
*/
export declare class DigitaloceanProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "digitalocean";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean digitalocean} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DigitaloceanProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DigitaloceanProviderConfig);
    private _apiEndpoint?;
    get apiEndpoint(): string | undefined;
    set apiEndpoint(value: string | undefined);
    resetApiEndpoint(): void;
    get apiEndpointInput(): string | undefined;
    private _spacesAccessId?;
    get spacesAccessId(): string | undefined;
    set spacesAccessId(value: string | undefined);
    resetSpacesAccessId(): void;
    get spacesAccessIdInput(): string | undefined;
    private _spacesEndpoint?;
    get spacesEndpoint(): string | undefined;
    set spacesEndpoint(value: string | undefined);
    resetSpacesEndpoint(): void;
    get spacesEndpointInput(): string | undefined;
    private _spacesSecretKey?;
    get spacesSecretKey(): string | undefined;
    set spacesSecretKey(value: string | undefined);
    resetSpacesSecretKey(): void;
    get spacesSecretKeyInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
