import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DropletConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#backups Droplet#backups}
    */
    readonly backups?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#droplet_agent Droplet#droplet_agent}
    */
    readonly dropletAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#graceful_shutdown Droplet#graceful_shutdown}
    */
    readonly gracefulShutdown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#id Droplet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#image Droplet#image}
    */
    readonly image: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#ipv6 Droplet#ipv6}
    */
    readonly ipv6?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#monitoring Droplet#monitoring}
    */
    readonly monitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#name Droplet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#private_networking Droplet#private_networking}
    */
    readonly privateNetworking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#region Droplet#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#resize_disk Droplet#resize_disk}
    */
    readonly resizeDisk?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#size Droplet#size}
    */
    readonly size: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#ssh_keys Droplet#ssh_keys}
    */
    readonly sshKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#tags Droplet#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#user_data Droplet#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#volume_ids Droplet#volume_ids}
    */
    readonly volumeIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#vpc_uuid Droplet#vpc_uuid}
    */
    readonly vpcUuid?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#timeouts Droplet#timeouts}
    */
    readonly timeouts?: DropletTimeouts;
}
export interface DropletTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#create Droplet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#delete Droplet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet#update Droplet#update}
    */
    readonly update?: string;
}
export declare function dropletTimeoutsToTerraform(struct?: DropletTimeoutsOutputReference | DropletTimeouts | cdktf.IResolvable): any;
export declare class DropletTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DropletTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DropletTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet digitalocean_droplet}
*/
export declare class Droplet extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_droplet";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/droplet digitalocean_droplet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DropletConfig
    */
    constructor(scope: Construct, id: string, config: DropletConfig);
    private _backups?;
    get backups(): boolean | cdktf.IResolvable;
    set backups(value: boolean | cdktf.IResolvable);
    resetBackups(): void;
    get backupsInput(): boolean | cdktf.IResolvable | undefined;
    get createdAt(): string;
    get disk(): number;
    private _dropletAgent?;
    get dropletAgent(): boolean | cdktf.IResolvable;
    set dropletAgent(value: boolean | cdktf.IResolvable);
    resetDropletAgent(): void;
    get dropletAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _gracefulShutdown?;
    get gracefulShutdown(): boolean | cdktf.IResolvable;
    set gracefulShutdown(value: boolean | cdktf.IResolvable);
    resetGracefulShutdown(): void;
    get gracefulShutdownInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    get ipv4Address(): string;
    get ipv4AddressPrivate(): string;
    private _ipv6?;
    get ipv6(): boolean | cdktf.IResolvable;
    set ipv6(value: boolean | cdktf.IResolvable);
    resetIpv6(): void;
    get ipv6Input(): boolean | cdktf.IResolvable | undefined;
    get ipv6Address(): string;
    get locked(): cdktf.IResolvable;
    get memory(): number;
    private _monitoring?;
    get monitoring(): boolean | cdktf.IResolvable;
    set monitoring(value: boolean | cdktf.IResolvable);
    resetMonitoring(): void;
    get monitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get priceHourly(): number;
    get priceMonthly(): number;
    private _privateNetworking?;
    get privateNetworking(): boolean | cdktf.IResolvable;
    set privateNetworking(value: boolean | cdktf.IResolvable);
    resetPrivateNetworking(): void;
    get privateNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _resizeDisk?;
    get resizeDisk(): boolean | cdktf.IResolvable;
    set resizeDisk(value: boolean | cdktf.IResolvable);
    resetResizeDisk(): void;
    get resizeDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    get sizeInput(): string | undefined;
    private _sshKeys?;
    get sshKeys(): string[];
    set sshKeys(value: string[]);
    resetSshKeys(): void;
    get sshKeysInput(): string[] | undefined;
    get status(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get urn(): string;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    get vcpus(): number;
    private _volumeIds?;
    get volumeIds(): string[];
    set volumeIds(value: string[]);
    resetVolumeIds(): void;
    get volumeIdsInput(): string[] | undefined;
    private _vpcUuid?;
    get vpcUuid(): string;
    set vpcUuid(value: string);
    resetVpcUuid(): void;
    get vpcUuidInput(): string | undefined;
    private _timeouts;
    get timeouts(): DropletTimeoutsOutputReference;
    putTimeouts(value: DropletTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DropletTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
