import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#droplet_ids Firewall#droplet_ids}
    */
    readonly dropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#id Firewall#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#name Firewall#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#tags Firewall#tags}
    */
    readonly tags?: string[];
    /**
    * inbound_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#inbound_rule Firewall#inbound_rule}
    */
    readonly inboundRule?: FirewallInboundRule[] | cdktf.IResolvable;
    /**
    * outbound_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#outbound_rule Firewall#outbound_rule}
    */
    readonly outboundRule?: FirewallOutboundRule[] | cdktf.IResolvable;
}
export interface FirewallPendingChanges {
}
export declare function firewallPendingChangesToTerraform(struct?: FirewallPendingChanges): any;
export declare class FirewallPendingChangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallPendingChanges | undefined;
    set internalValue(value: FirewallPendingChanges | undefined);
    get dropletId(): number;
    get removing(): cdktf.IResolvable;
    get status(): string;
}
export declare class FirewallPendingChangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallPendingChangesOutputReference;
}
export interface FirewallInboundRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#port_range Firewall#port_range}
    */
    readonly portRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#protocol Firewall#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#source_addresses Firewall#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#source_droplet_ids Firewall#source_droplet_ids}
    */
    readonly sourceDropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#source_kubernetes_ids Firewall#source_kubernetes_ids}
    */
    readonly sourceKubernetesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#source_load_balancer_uids Firewall#source_load_balancer_uids}
    */
    readonly sourceLoadBalancerUids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#source_tags Firewall#source_tags}
    */
    readonly sourceTags?: string[];
}
export declare function firewallInboundRuleToTerraform(struct?: FirewallInboundRule | cdktf.IResolvable): any;
export declare class FirewallInboundRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallInboundRule | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallInboundRule | cdktf.IResolvable | undefined);
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _sourceAddresses?;
    get sourceAddresses(): string[];
    set sourceAddresses(value: string[]);
    resetSourceAddresses(): void;
    get sourceAddressesInput(): string[] | undefined;
    private _sourceDropletIds?;
    get sourceDropletIds(): number[];
    set sourceDropletIds(value: number[]);
    resetSourceDropletIds(): void;
    get sourceDropletIdsInput(): number[] | undefined;
    private _sourceKubernetesIds?;
    get sourceKubernetesIds(): string[];
    set sourceKubernetesIds(value: string[]);
    resetSourceKubernetesIds(): void;
    get sourceKubernetesIdsInput(): string[] | undefined;
    private _sourceLoadBalancerUids?;
    get sourceLoadBalancerUids(): string[];
    set sourceLoadBalancerUids(value: string[]);
    resetSourceLoadBalancerUids(): void;
    get sourceLoadBalancerUidsInput(): string[] | undefined;
    private _sourceTags?;
    get sourceTags(): string[];
    set sourceTags(value: string[]);
    resetSourceTags(): void;
    get sourceTagsInput(): string[] | undefined;
}
export declare class FirewallInboundRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallInboundRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallInboundRuleOutputReference;
}
export interface FirewallOutboundRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#destination_addresses Firewall#destination_addresses}
    */
    readonly destinationAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#destination_droplet_ids Firewall#destination_droplet_ids}
    */
    readonly destinationDropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#destination_kubernetes_ids Firewall#destination_kubernetes_ids}
    */
    readonly destinationKubernetesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#destination_load_balancer_uids Firewall#destination_load_balancer_uids}
    */
    readonly destinationLoadBalancerUids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#destination_tags Firewall#destination_tags}
    */
    readonly destinationTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#port_range Firewall#port_range}
    */
    readonly portRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall#protocol Firewall#protocol}
    */
    readonly protocol: string;
}
export declare function firewallOutboundRuleToTerraform(struct?: FirewallOutboundRule | cdktf.IResolvable): any;
export declare class FirewallOutboundRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallOutboundRule | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallOutboundRule | cdktf.IResolvable | undefined);
    private _destinationAddresses?;
    get destinationAddresses(): string[];
    set destinationAddresses(value: string[]);
    resetDestinationAddresses(): void;
    get destinationAddressesInput(): string[] | undefined;
    private _destinationDropletIds?;
    get destinationDropletIds(): number[];
    set destinationDropletIds(value: number[]);
    resetDestinationDropletIds(): void;
    get destinationDropletIdsInput(): number[] | undefined;
    private _destinationKubernetesIds?;
    get destinationKubernetesIds(): string[];
    set destinationKubernetesIds(value: string[]);
    resetDestinationKubernetesIds(): void;
    get destinationKubernetesIdsInput(): string[] | undefined;
    private _destinationLoadBalancerUids?;
    get destinationLoadBalancerUids(): string[];
    set destinationLoadBalancerUids(value: string[]);
    resetDestinationLoadBalancerUids(): void;
    get destinationLoadBalancerUidsInput(): string[] | undefined;
    private _destinationTags?;
    get destinationTags(): string[];
    set destinationTags(value: string[]);
    resetDestinationTags(): void;
    get destinationTagsInput(): string[] | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class FirewallOutboundRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallOutboundRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallOutboundRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall digitalocean_firewall}
*/
export declare class Firewall extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_firewall";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/firewall digitalocean_firewall} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallConfig
    */
    constructor(scope: Construct, id: string, config: FirewallConfig);
    get createdAt(): string;
    private _dropletIds?;
    get dropletIds(): number[];
    set dropletIds(value: number[]);
    resetDropletIds(): void;
    get dropletIdsInput(): number[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pendingChanges;
    get pendingChanges(): FirewallPendingChangesList;
    get status(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _inboundRule;
    get inboundRule(): FirewallInboundRuleList;
    putInboundRule(value: FirewallInboundRule[] | cdktf.IResolvable): void;
    resetInboundRule(): void;
    get inboundRuleInput(): cdktf.IResolvable | FirewallInboundRule[] | undefined;
    private _outboundRule;
    get outboundRule(): FirewallOutboundRuleList;
    putOutboundRule(value: FirewallOutboundRule[] | cdktf.IResolvable): void;
    resetOutboundRule(): void;
    get outboundRuleInput(): cdktf.IResolvable | FirewallOutboundRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
