import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#auto_upgrade KubernetesCluster#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#ha KubernetesCluster#ha}
    */
    readonly ha?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#region KubernetesCluster#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#surge_upgrade KubernetesCluster#surge_upgrade}
    */
    readonly surgeUpgrade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#tags KubernetesCluster#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#version KubernetesCluster#version}
    */
    readonly version: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#vpc_uuid KubernetesCluster#vpc_uuid}
    */
    readonly vpcUuid?: string;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#maintenance_policy KubernetesCluster#maintenance_policy}
    */
    readonly maintenancePolicy?: KubernetesClusterMaintenancePolicy;
    /**
    * node_pool block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#node_pool KubernetesCluster#node_pool}
    */
    readonly nodePool: KubernetesClusterNodePool;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#timeouts KubernetesCluster#timeouts}
    */
    readonly timeouts?: KubernetesClusterTimeouts;
}
export interface KubernetesClusterKubeConfig {
}
export declare function kubernetesClusterKubeConfigToTerraform(struct?: KubernetesClusterKubeConfig): any;
export declare class KubernetesClusterKubeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterKubeConfig | undefined;
    set internalValue(value: KubernetesClusterKubeConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get expiresAt(): string;
    get host(): string;
    get rawConfig(): string;
    get token(): string;
}
export declare class KubernetesClusterKubeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterKubeConfigOutputReference;
}
export interface KubernetesClusterMaintenancePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#day KubernetesCluster#day}
    */
    readonly day?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#start_time KubernetesCluster#start_time}
    */
    readonly startTime?: string;
}
export declare function kubernetesClusterMaintenancePolicyToTerraform(struct?: KubernetesClusterMaintenancePolicyOutputReference | KubernetesClusterMaintenancePolicy): any;
export declare class KubernetesClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterMaintenancePolicy | undefined;
    set internalValue(value: KubernetesClusterMaintenancePolicy | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    resetDay(): void;
    get dayInput(): string | undefined;
    get duration(): string;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface KubernetesClusterNodePoolNodes {
}
export declare function kubernetesClusterNodePoolNodesToTerraform(struct?: KubernetesClusterNodePoolNodes): any;
export declare class KubernetesClusterNodePoolNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterNodePoolNodes | undefined;
    set internalValue(value: KubernetesClusterNodePoolNodes | undefined);
    get createdAt(): string;
    get dropletId(): string;
    get id(): string;
    get name(): string;
    get status(): string;
    get updatedAt(): string;
}
export declare class KubernetesClusterNodePoolNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterNodePoolNodesOutputReference;
}
export interface KubernetesClusterNodePoolTaint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#effect KubernetesCluster#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#key KubernetesCluster#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#value KubernetesCluster#value}
    */
    readonly value: string;
}
export declare function kubernetesClusterNodePoolTaintToTerraform(struct?: KubernetesClusterNodePoolTaint | cdktf.IResolvable): any;
export declare class KubernetesClusterNodePoolTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterNodePoolTaint | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterNodePoolTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class KubernetesClusterNodePoolTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterNodePoolTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterNodePoolTaintOutputReference;
}
export interface KubernetesClusterNodePool {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#auto_scale KubernetesCluster#auto_scale}
    */
    readonly autoScale?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#labels KubernetesCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#max_nodes KubernetesCluster#max_nodes}
    */
    readonly maxNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#min_nodes KubernetesCluster#min_nodes}
    */
    readonly minNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#node_count KubernetesCluster#node_count}
    */
    readonly nodeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#size KubernetesCluster#size}
    */
    readonly size: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#tags KubernetesCluster#tags}
    */
    readonly tags?: string[];
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#taint KubernetesCluster#taint}
    */
    readonly taint?: KubernetesClusterNodePoolTaint[] | cdktf.IResolvable;
}
export declare function kubernetesClusterNodePoolToTerraform(struct?: KubernetesClusterNodePoolOutputReference | KubernetesClusterNodePool): any;
export declare class KubernetesClusterNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePool | undefined;
    set internalValue(value: KubernetesClusterNodePool | undefined);
    get actualNodeCount(): number;
    private _autoScale?;
    get autoScale(): boolean | cdktf.IResolvable;
    set autoScale(value: boolean | cdktf.IResolvable);
    resetAutoScale(): void;
    get autoScaleInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxNodes?;
    get maxNodes(): number;
    set maxNodes(value: number);
    resetMaxNodes(): void;
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number;
    set minNodes(value: number);
    resetMinNodes(): void;
    get minNodesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodes;
    get nodes(): KubernetesClusterNodePoolNodesList;
    private _size?;
    get size(): string;
    set size(value: string);
    get sizeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint;
    get taint(): KubernetesClusterNodePoolTaintList;
    putTaint(value: KubernetesClusterNodePoolTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | KubernetesClusterNodePoolTaint[] | undefined;
}
export interface KubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster#create KubernetesCluster#create}
    */
    readonly create?: string;
}
export declare function kubernetesClusterTimeoutsToTerraform(struct?: KubernetesClusterTimeoutsOutputReference | KubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class KubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster digitalocean_kubernetes_cluster}
*/
export declare class KubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_kubernetes_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/kubernetes_cluster digitalocean_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesClusterConfig);
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    get clusterSubnet(): string;
    get createdAt(): string;
    get endpoint(): string;
    private _ha?;
    get ha(): boolean | cdktf.IResolvable;
    set ha(value: boolean | cdktf.IResolvable);
    resetHa(): void;
    get haInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipv4Address(): string;
    private _kubeConfig;
    get kubeConfig(): KubernetesClusterKubeConfigList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get serviceSubnet(): string;
    get status(): string;
    private _surgeUpgrade?;
    get surgeUpgrade(): boolean | cdktf.IResolvable;
    set surgeUpgrade(value: boolean | cdktf.IResolvable);
    resetSurgeUpgrade(): void;
    get surgeUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get updatedAt(): string;
    get urn(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _vpcUuid?;
    get vpcUuid(): string;
    set vpcUuid(value: string);
    resetVpcUuid(): void;
    get vpcUuidInput(): string | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): KubernetesClusterMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: KubernetesClusterMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): KubernetesClusterMaintenancePolicy | undefined;
    private _nodePool;
    get nodePool(): KubernetesClusterNodePoolOutputReference;
    putNodePool(value: KubernetesClusterNodePool): void;
    get nodePoolInput(): KubernetesClusterNodePool | undefined;
    private _timeouts;
    get timeouts(): KubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: KubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
