import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#algorithm Loadbalancer#algorithm}
    */
    readonly algorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#disable_lets_encrypt_dns_records Loadbalancer#disable_lets_encrypt_dns_records}
    */
    readonly disableLetsEncryptDnsRecords?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#droplet_ids Loadbalancer#droplet_ids}
    */
    readonly dropletIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#droplet_tag Loadbalancer#droplet_tag}
    */
    readonly dropletTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#enable_backend_keepalive Loadbalancer#enable_backend_keepalive}
    */
    readonly enableBackendKeepalive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#enable_proxy_protocol Loadbalancer#enable_proxy_protocol}
    */
    readonly enableProxyProtocol?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#id Loadbalancer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#name Loadbalancer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#redirect_http_to_https Loadbalancer#redirect_http_to_https}
    */
    readonly redirectHttpToHttps?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#region Loadbalancer#region}
    */
    readonly region: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#size Loadbalancer#size}
    */
    readonly size?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#size_unit Loadbalancer#size_unit}
    */
    readonly sizeUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#vpc_uuid Loadbalancer#vpc_uuid}
    */
    readonly vpcUuid?: string;
    /**
    * forwarding_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#forwarding_rule Loadbalancer#forwarding_rule}
    */
    readonly forwardingRule: LoadbalancerForwardingRule[] | cdktf.IResolvable;
    /**
    * healthcheck block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#healthcheck Loadbalancer#healthcheck}
    */
    readonly healthcheck?: LoadbalancerHealthcheck;
    /**
    * sticky_sessions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#sticky_sessions Loadbalancer#sticky_sessions}
    */
    readonly stickySessions?: LoadbalancerStickySessions;
}
export interface LoadbalancerForwardingRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#certificate_id Loadbalancer#certificate_id}
    */
    readonly certificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#certificate_name Loadbalancer#certificate_name}
    */
    readonly certificateName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#entry_port Loadbalancer#entry_port}
    */
    readonly entryPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#entry_protocol Loadbalancer#entry_protocol}
    */
    readonly entryProtocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#target_port Loadbalancer#target_port}
    */
    readonly targetPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#target_protocol Loadbalancer#target_protocol}
    */
    readonly targetProtocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#tls_passthrough Loadbalancer#tls_passthrough}
    */
    readonly tlsPassthrough?: boolean | cdktf.IResolvable;
}
export declare function loadbalancerForwardingRuleToTerraform(struct?: LoadbalancerForwardingRule | cdktf.IResolvable): any;
export declare class LoadbalancerForwardingRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LoadbalancerForwardingRule | cdktf.IResolvable | undefined;
    set internalValue(value: LoadbalancerForwardingRule | cdktf.IResolvable | undefined);
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    resetCertificateId(): void;
    get certificateIdInput(): string | undefined;
    private _certificateName?;
    get certificateName(): string;
    set certificateName(value: string);
    resetCertificateName(): void;
    get certificateNameInput(): string | undefined;
    private _entryPort?;
    get entryPort(): number;
    set entryPort(value: number);
    get entryPortInput(): number | undefined;
    private _entryProtocol?;
    get entryProtocol(): string;
    set entryProtocol(value: string);
    get entryProtocolInput(): string | undefined;
    private _targetPort?;
    get targetPort(): number;
    set targetPort(value: number);
    get targetPortInput(): number | undefined;
    private _targetProtocol?;
    get targetProtocol(): string;
    set targetProtocol(value: string);
    get targetProtocolInput(): string | undefined;
    private _tlsPassthrough?;
    get tlsPassthrough(): boolean | cdktf.IResolvable;
    set tlsPassthrough(value: boolean | cdktf.IResolvable);
    resetTlsPassthrough(): void;
    get tlsPassthroughInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class LoadbalancerForwardingRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LoadbalancerForwardingRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LoadbalancerForwardingRuleOutputReference;
}
export interface LoadbalancerHealthcheck {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#check_interval_seconds Loadbalancer#check_interval_seconds}
    */
    readonly checkIntervalSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#healthy_threshold Loadbalancer#healthy_threshold}
    */
    readonly healthyThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#path Loadbalancer#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#port Loadbalancer#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#protocol Loadbalancer#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#response_timeout_seconds Loadbalancer#response_timeout_seconds}
    */
    readonly responseTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#unhealthy_threshold Loadbalancer#unhealthy_threshold}
    */
    readonly unhealthyThreshold?: number;
}
export declare function loadbalancerHealthcheckToTerraform(struct?: LoadbalancerHealthcheckOutputReference | LoadbalancerHealthcheck): any;
export declare class LoadbalancerHealthcheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerHealthcheck | undefined;
    set internalValue(value: LoadbalancerHealthcheck | undefined);
    private _checkIntervalSeconds?;
    get checkIntervalSeconds(): number;
    set checkIntervalSeconds(value: number);
    resetCheckIntervalSeconds(): void;
    get checkIntervalSecondsInput(): number | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number;
    set healthyThreshold(value: number);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _responseTimeoutSeconds?;
    get responseTimeoutSeconds(): number;
    set responseTimeoutSeconds(value: number);
    resetResponseTimeoutSeconds(): void;
    get responseTimeoutSecondsInput(): number | undefined;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
}
export interface LoadbalancerStickySessions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#cookie_name Loadbalancer#cookie_name}
    */
    readonly cookieName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#cookie_ttl_seconds Loadbalancer#cookie_ttl_seconds}
    */
    readonly cookieTtlSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer#type Loadbalancer#type}
    */
    readonly type?: string;
}
export declare function loadbalancerStickySessionsToTerraform(struct?: LoadbalancerStickySessionsOutputReference | LoadbalancerStickySessions): any;
export declare class LoadbalancerStickySessionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerStickySessions | undefined;
    set internalValue(value: LoadbalancerStickySessions | undefined);
    private _cookieName?;
    get cookieName(): string;
    set cookieName(value: string);
    resetCookieName(): void;
    get cookieNameInput(): string | undefined;
    private _cookieTtlSeconds?;
    get cookieTtlSeconds(): number;
    set cookieTtlSeconds(value: number);
    resetCookieTtlSeconds(): void;
    get cookieTtlSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer digitalocean_loadbalancer}
*/
export declare class Loadbalancer extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_loadbalancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/loadbalancer digitalocean_loadbalancer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerConfig);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _disableLetsEncryptDnsRecords?;
    get disableLetsEncryptDnsRecords(): boolean | cdktf.IResolvable;
    set disableLetsEncryptDnsRecords(value: boolean | cdktf.IResolvable);
    resetDisableLetsEncryptDnsRecords(): void;
    get disableLetsEncryptDnsRecordsInput(): boolean | cdktf.IResolvable | undefined;
    private _dropletIds?;
    get dropletIds(): number[];
    set dropletIds(value: number[]);
    resetDropletIds(): void;
    get dropletIdsInput(): number[] | undefined;
    private _dropletTag?;
    get dropletTag(): string;
    set dropletTag(value: string);
    resetDropletTag(): void;
    get dropletTagInput(): string | undefined;
    private _enableBackendKeepalive?;
    get enableBackendKeepalive(): boolean | cdktf.IResolvable;
    set enableBackendKeepalive(value: boolean | cdktf.IResolvable);
    resetEnableBackendKeepalive(): void;
    get enableBackendKeepaliveInput(): boolean | cdktf.IResolvable | undefined;
    private _enableProxyProtocol?;
    get enableProxyProtocol(): boolean | cdktf.IResolvable;
    set enableProxyProtocol(value: boolean | cdktf.IResolvable);
    resetEnableProxyProtocol(): void;
    get enableProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ip(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectHttpToHttps?;
    get redirectHttpToHttps(): boolean | cdktf.IResolvable;
    set redirectHttpToHttps(value: boolean | cdktf.IResolvable);
    resetRedirectHttpToHttps(): void;
    get redirectHttpToHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    resetSize(): void;
    get sizeInput(): string | undefined;
    private _sizeUnit?;
    get sizeUnit(): number;
    set sizeUnit(value: number);
    resetSizeUnit(): void;
    get sizeUnitInput(): number | undefined;
    get status(): string;
    get urn(): string;
    private _vpcUuid?;
    get vpcUuid(): string;
    set vpcUuid(value: string);
    resetVpcUuid(): void;
    get vpcUuidInput(): string | undefined;
    private _forwardingRule;
    get forwardingRule(): LoadbalancerForwardingRuleList;
    putForwardingRule(value: LoadbalancerForwardingRule[] | cdktf.IResolvable): void;
    get forwardingRuleInput(): cdktf.IResolvable | LoadbalancerForwardingRule[] | undefined;
    private _healthcheck;
    get healthcheck(): LoadbalancerHealthcheckOutputReference;
    putHealthcheck(value: LoadbalancerHealthcheck): void;
    resetHealthcheck(): void;
    get healthcheckInput(): LoadbalancerHealthcheck | undefined;
    private _stickySessions;
    get stickySessions(): LoadbalancerStickySessionsOutputReference;
    putStickySessions(value: LoadbalancerStickySessions): void;
    resetStickySessions(): void;
    get stickySessionsInput(): LoadbalancerStickySessions | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
