import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * The comparison operator to use for value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#compare MonitorAlert#compare}
    */
    readonly compare: string;
    /**
    * Description of the alert policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#description MonitorAlert#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#enabled MonitorAlert#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The droplets to apply the alert policy to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#entities MonitorAlert#entities}
    */
    readonly entities?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#id MonitorAlert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#tags MonitorAlert#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#type MonitorAlert#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#value MonitorAlert#value}
    */
    readonly value: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#window MonitorAlert#window}
    */
    readonly window: string;
    /**
    * alerts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#alerts MonitorAlert#alerts}
    */
    readonly alerts: MonitorAlertAlerts;
}
export interface MonitorAlertAlertsSlack {
    /**
    * The Slack channel to send alerts to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#channel MonitorAlert#channel}
    */
    readonly channel: string;
    /**
    * The webhook URL for Slack
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#url MonitorAlert#url}
    */
    readonly url: string;
}
export declare function monitorAlertAlertsSlackToTerraform(struct?: MonitorAlertAlertsSlack | cdktf.IResolvable): any;
export declare class MonitorAlertAlertsSlackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertAlertsSlack | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertAlertsSlack | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    get channelInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class MonitorAlertAlertsSlackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertAlertsSlack[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertAlertsSlackOutputReference;
}
export interface MonitorAlertAlerts {
    /**
    * List of email addresses to sent notifications to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#email MonitorAlert#email}
    */
    readonly email?: string[];
    /**
    * slack block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert#slack MonitorAlert#slack}
    */
    readonly slack?: MonitorAlertAlertsSlack[] | cdktf.IResolvable;
}
export declare function monitorAlertAlertsToTerraform(struct?: MonitorAlertAlertsOutputReference | MonitorAlertAlerts): any;
export declare class MonitorAlertAlertsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertAlerts | undefined;
    set internalValue(value: MonitorAlertAlerts | undefined);
    private _email?;
    get email(): string[];
    set email(value: string[]);
    resetEmail(): void;
    get emailInput(): string[] | undefined;
    private _slack;
    get slack(): MonitorAlertAlertsSlackList;
    putSlack(value: MonitorAlertAlertsSlack[] | cdktf.IResolvable): void;
    resetSlack(): void;
    get slackInput(): cdktf.IResolvable | MonitorAlertAlertsSlack[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert digitalocean_monitor_alert}
*/
export declare class MonitorAlert extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_monitor_alert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/monitor_alert digitalocean_monitor_alert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorAlertConfig
    */
    constructor(scope: Construct, id: string, config: MonitorAlertConfig);
    private _compare?;
    get compare(): string;
    set compare(value: string);
    get compareInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entities?;
    get entities(): string[];
    set entities(value: string[]);
    resetEntities(): void;
    get entitiesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get uuid(): string;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    private _window?;
    get window(): string;
    set window(value: string);
    get windowInput(): string | undefined;
    private _alerts;
    get alerts(): MonitorAlertAlertsOutputReference;
    putAlerts(value: MonitorAlertAlerts): void;
    get alertsInput(): MonitorAlertAlerts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
