import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * the description of the project
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#description Project#description}
    */
    readonly description?: string;
    /**
    * the environment of the project's resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#environment Project#environment}
    */
    readonly environment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#id Project#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * determine if the project is the default or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#is_default Project#is_default}
    */
    readonly isDefault?: boolean | cdktf.IResolvable;
    /**
    * the human-readable name for the project
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#name Project#name}
    */
    readonly name: string;
    /**
    * the purpose of the project
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#purpose Project#purpose}
    */
    readonly purpose?: string;
    /**
    * the resources associated with the project
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/project#resources Project#resources}
    */
    readonly resources?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/project digitalocean_project}
*/
export declare class Project extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/project digitalocean_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    resetIsDefault(): void;
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get ownerId(): number;
    get ownerUuid(): string;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
