import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ReservedIpAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/reserved_ip_assignment#droplet_id ReservedIpAssignment#droplet_id}
    */
    readonly dropletId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/reserved_ip_assignment#id ReservedIpAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/reserved_ip_assignment#ip_address ReservedIpAssignment#ip_address}
    */
    readonly ipAddress: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/reserved_ip_assignment digitalocean_reserved_ip_assignment}
*/
export declare class ReservedIpAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_reserved_ip_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/reserved_ip_assignment digitalocean_reserved_ip_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ReservedIpAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: ReservedIpAssignmentConfig);
    private _dropletId?;
    get dropletId(): number;
    set dropletId(value: number);
    get dropletIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
