import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpacesBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Canned ACL applied on bucket creation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#acl SpacesBucket#acl}
    */
    readonly acl?: string;
    /**
    * Unless true, the bucket will only be destroyed if empty
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#force_destroy SpacesBucket#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#id SpacesBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Bucket name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#name SpacesBucket#name}
    */
    readonly name: string;
    /**
    * Bucket region
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#region SpacesBucket#region}
    */
    readonly region?: string;
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#cors_rule SpacesBucket#cors_rule}
    */
    readonly corsRule?: SpacesBucketCorsRule[] | cdktf.IResolvable;
    /**
    * lifecycle_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#lifecycle_rule SpacesBucket#lifecycle_rule}
    */
    readonly lifecycleRule?: SpacesBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * versioning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#versioning SpacesBucket#versioning}
    */
    readonly versioning?: SpacesBucketVersioning;
}
export interface SpacesBucketCorsRule {
    /**
    * A list of headers that will be included in the CORS preflight request's Access-Control-Request-Headers. A header may contain one wildcard (e.g. x-amz-*).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#allowed_headers SpacesBucket#allowed_headers}
    */
    readonly allowedHeaders?: string[];
    /**
    * A list of HTTP methods (e.g. GET) which are allowed from the specified origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#allowed_methods SpacesBucket#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#allowed_origins SpacesBucket#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#max_age_seconds SpacesBucket#max_age_seconds}
    */
    readonly maxAgeSeconds?: number;
}
export declare function spacesBucketCorsRuleToTerraform(struct?: SpacesBucketCorsRule | cdktf.IResolvable): any;
export declare class SpacesBucketCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpacesBucketCorsRule | cdktf.IResolvable | undefined;
    set internalValue(value: SpacesBucketCorsRule | cdktf.IResolvable | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    resetAllowedHeaders(): void;
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _maxAgeSeconds?;
    get maxAgeSeconds(): number;
    set maxAgeSeconds(value: number);
    resetMaxAgeSeconds(): void;
    get maxAgeSecondsInput(): number | undefined;
}
export declare class SpacesBucketCorsRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpacesBucketCorsRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpacesBucketCorsRuleOutputReference;
}
export interface SpacesBucketLifecycleRuleExpiration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#date SpacesBucket#date}
    */
    readonly date?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#days SpacesBucket#days}
    */
    readonly days?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#expired_object_delete_marker SpacesBucket#expired_object_delete_marker}
    */
    readonly expiredObjectDeleteMarker?: boolean | cdktf.IResolvable;
}
export declare function spacesBucketLifecycleRuleExpirationToTerraform(struct?: SpacesBucketLifecycleRuleExpirationOutputReference | SpacesBucketLifecycleRuleExpiration): any;
export declare class SpacesBucketLifecycleRuleExpirationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpacesBucketLifecycleRuleExpiration | undefined;
    set internalValue(value: SpacesBucketLifecycleRuleExpiration | undefined);
    private _date?;
    get date(): string;
    set date(value: string);
    resetDate(): void;
    get dateInput(): string | undefined;
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _expiredObjectDeleteMarker?;
    get expiredObjectDeleteMarker(): boolean | cdktf.IResolvable;
    set expiredObjectDeleteMarker(value: boolean | cdktf.IResolvable);
    resetExpiredObjectDeleteMarker(): void;
    get expiredObjectDeleteMarkerInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SpacesBucketLifecycleRuleNoncurrentVersionExpiration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#days SpacesBucket#days}
    */
    readonly days?: number;
}
export declare function spacesBucketLifecycleRuleNoncurrentVersionExpirationToTerraform(struct?: SpacesBucketLifecycleRuleNoncurrentVersionExpirationOutputReference | SpacesBucketLifecycleRuleNoncurrentVersionExpiration): any;
export declare class SpacesBucketLifecycleRuleNoncurrentVersionExpirationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpacesBucketLifecycleRuleNoncurrentVersionExpiration | undefined;
    set internalValue(value: SpacesBucketLifecycleRuleNoncurrentVersionExpiration | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
}
export interface SpacesBucketLifecycleRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#abort_incomplete_multipart_upload_days SpacesBucket#abort_incomplete_multipart_upload_days}
    */
    readonly abortIncompleteMultipartUploadDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#enabled SpacesBucket#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#id SpacesBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#prefix SpacesBucket#prefix}
    */
    readonly prefix?: string;
    /**
    * expiration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#expiration SpacesBucket#expiration}
    */
    readonly expiration?: SpacesBucketLifecycleRuleExpiration;
    /**
    * noncurrent_version_expiration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#noncurrent_version_expiration SpacesBucket#noncurrent_version_expiration}
    */
    readonly noncurrentVersionExpiration?: SpacesBucketLifecycleRuleNoncurrentVersionExpiration;
}
export declare function spacesBucketLifecycleRuleToTerraform(struct?: SpacesBucketLifecycleRule | cdktf.IResolvable): any;
export declare class SpacesBucketLifecycleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpacesBucketLifecycleRule | cdktf.IResolvable | undefined;
    set internalValue(value: SpacesBucketLifecycleRule | cdktf.IResolvable | undefined);
    private _abortIncompleteMultipartUploadDays?;
    get abortIncompleteMultipartUploadDays(): number;
    set abortIncompleteMultipartUploadDays(value: number);
    resetAbortIncompleteMultipartUploadDays(): void;
    get abortIncompleteMultipartUploadDaysInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _expiration;
    get expiration(): SpacesBucketLifecycleRuleExpirationOutputReference;
    putExpiration(value: SpacesBucketLifecycleRuleExpiration): void;
    resetExpiration(): void;
    get expirationInput(): SpacesBucketLifecycleRuleExpiration | undefined;
    private _noncurrentVersionExpiration;
    get noncurrentVersionExpiration(): SpacesBucketLifecycleRuleNoncurrentVersionExpirationOutputReference;
    putNoncurrentVersionExpiration(value: SpacesBucketLifecycleRuleNoncurrentVersionExpiration): void;
    resetNoncurrentVersionExpiration(): void;
    get noncurrentVersionExpirationInput(): SpacesBucketLifecycleRuleNoncurrentVersionExpiration | undefined;
}
export declare class SpacesBucketLifecycleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpacesBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpacesBucketLifecycleRuleOutputReference;
}
export interface SpacesBucketVersioning {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket#enabled SpacesBucket#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function spacesBucketVersioningToTerraform(struct?: SpacesBucketVersioningOutputReference | SpacesBucketVersioning): any;
export declare class SpacesBucketVersioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpacesBucketVersioning | undefined;
    set internalValue(value: SpacesBucketVersioning | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket digitalocean_spaces_bucket}
*/
export declare class SpacesBucket extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_spaces_bucket";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/spaces_bucket digitalocean_spaces_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpacesBucketConfig
    */
    constructor(scope: Construct, id: string, config: SpacesBucketConfig);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    resetAcl(): void;
    get aclInput(): string | undefined;
    get bucketDomainName(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get urn(): string;
    private _corsRule;
    get corsRule(): SpacesBucketCorsRuleList;
    putCorsRule(value: SpacesBucketCorsRule[] | cdktf.IResolvable): void;
    resetCorsRule(): void;
    get corsRuleInput(): cdktf.IResolvable | SpacesBucketCorsRule[] | undefined;
    private _lifecycleRule;
    get lifecycleRule(): SpacesBucketLifecycleRuleList;
    putLifecycleRule(value: SpacesBucketLifecycleRule[] | cdktf.IResolvable): void;
    resetLifecycleRule(): void;
    get lifecycleRuleInput(): cdktf.IResolvable | SpacesBucketLifecycleRule[] | undefined;
    private _versioning;
    get versioning(): SpacesBucketVersioningOutputReference;
    putVersioning(value: SpacesBucketVersioning): void;
    resetVersioning(): void;
    get versioningInput(): SpacesBucketVersioning | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
