import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SshKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/ssh_key#id SshKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/ssh_key#name SshKey#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/ssh_key#public_key SshKey#public_key}
    */
    readonly publicKey: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/ssh_key digitalocean_ssh_key}
*/
export declare class SshKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_ssh_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/ssh_key digitalocean_ssh_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SshKeyConfig
    */
    constructor(scope: Construct, id: string, config: SshKeyConfig);
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    get publicKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
