import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/tag#id Tag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/tag#name Tag#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/tag digitalocean_tag}
*/
export declare class Tag extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/tag digitalocean_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagConfig
    */
    constructor(scope: Construct, id: string, config: TagConfig);
    get databasesCount(): number;
    get dropletsCount(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imagesCount(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get totalResourceCount(): number;
    get volumeSnapshotsCount(): number;
    get volumesCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
