import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VolumeAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/volume_attachment#droplet_id VolumeAttachment#droplet_id}
    */
    readonly dropletId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/volume_attachment#id VolumeAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/volume_attachment#volume_id VolumeAttachment#volume_id}
    */
    readonly volumeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/volume_attachment digitalocean_volume_attachment}
*/
export declare class VolumeAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_volume_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/volume_attachment digitalocean_volume_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VolumeAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: VolumeAttachmentConfig);
    private _dropletId?;
    get dropletId(): number;
    set dropletId(value: number);
    get dropletIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
