import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-form description for the VPC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#description Vpc#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#id Vpc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The range of IP addresses for the VPC in CIDR notation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#ip_range Vpc#ip_range}
    */
    readonly ipRange?: string;
    /**
    * The name of the VPC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#name Vpc#name}
    */
    readonly name: string;
    /**
    * DigitalOcean region slug for the VPC's location
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#region Vpc#region}
    */
    readonly region: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#timeouts Vpc#timeouts}
    */
    readonly timeouts?: VpcTimeouts;
}
export interface VpcTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc#delete Vpc#delete}
    */
    readonly delete?: string;
}
export declare function vpcTimeoutsToTerraform(struct?: VpcTimeoutsOutputReference | VpcTimeouts | cdktf.IResolvable): any;
export declare class VpcTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpcTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpcTimeouts | cdktf.IResolvable | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc digitalocean_vpc}
*/
export declare class Vpc extends cdktf.TerraformResource {
    static readonly tfResourceType = "digitalocean_vpc";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/digitalocean/r/vpc digitalocean_vpc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcConfig
    */
    constructor(scope: Construct, id: string, config: VpcConfig);
    get createdAt(): string;
    get default(): cdktf.IResolvable;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipRange?;
    get ipRange(): string;
    set ipRange(value: string);
    resetIpRange(): void;
    get ipRangeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get urn(): string;
    private _timeouts;
    get timeouts(): VpcTimeoutsOutputReference;
    putTimeouts(value: VpcTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpcTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
