# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlinkJarApplicationVersionArgs', 'FlinkJarApplicationVersion']

@pulumi.input_type
class FlinkJarApplicationVersionArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a FlinkJarApplicationVersion resource.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source: The path to the jar file to upload.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        Application Id. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the jar file to upload.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _FlinkJarApplicationVersionState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 file_infos: Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationVersionFileInfoArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering FlinkJarApplicationVersion resources.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] application_version_id: ApplicationVersion ID.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] created_by: The creator of this entity.
        :param pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationVersionFileInfoArgs']]] file_infos: Flink JarApplicationVersion FileInfo.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source: The path to the jar file to upload.
        :param pulumi.Input[_builtins.str] source_checksum: The sha256 checksum of the jar file to upload.
        :param pulumi.Input[_builtins.int] version: Version number.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_version_id is not None:
            pulumi.set(__self__, "application_version_id", application_version_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if file_infos is not None:
            pulumi.set(__self__, "file_infos", file_infos)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_checksum is not None:
            pulumi.set(__self__, "source_checksum", source_checksum)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Id. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationVersionId")
    def application_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ApplicationVersion ID.
        """
        return pulumi.get(self, "application_version_id")

    @application_version_id.setter
    def application_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_version_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of this entity.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="fileInfos")
    def file_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationVersionFileInfoArgs']]]]:
        """
        Flink JarApplicationVersion FileInfo.
        """
        return pulumi.get(self, "file_infos")

    @file_infos.setter
    def file_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationVersionFileInfoArgs']]]]):
        pulumi.set(self, "file_infos", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the jar file to upload.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceChecksum")
    def source_checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sha256 checksum of the jar file to upload.
        """
        return pulumi.get(self, "source_checksum")

    @source_checksum.setter
    def source_checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_checksum", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aiven:index/flinkJarApplicationVersion:FlinkJarApplicationVersion")
class FlinkJarApplicationVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an Aiven for Apache Flink® jar application version.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example = aiven.Flink("example",
            project=example_aiven_project["project"],
            service_name="example-flink-service",
            cloud_name="google-europe-west1",
            plan="business-4",
            maintenance_window_dow="monday",
            maintenance_window_time="04:00:00",
            flink_user_config={
                "custom_code": True,
            })
        example_flink_jar_application = aiven.FlinkJarApplication("example",
            project=example.project,
            service_name=example.service_name,
            name="example-app-jar")
        example_flink_jar_application_version = aiven.FlinkJarApplicationVersion("example",
            project=example.project,
            service_name=example.service_name,
            application_id=example_flink_jar_application.application_id,
            source="./example.jar")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/flinkJarApplicationVersion:FlinkJarApplicationVersion example PROJECT/SERVICE_NAME/APPLICATION_ID/APPLICATION_VERSION_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source: The path to the jar file to upload.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkJarApplicationVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an Aiven for Apache Flink® jar application version.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example = aiven.Flink("example",
            project=example_aiven_project["project"],
            service_name="example-flink-service",
            cloud_name="google-europe-west1",
            plan="business-4",
            maintenance_window_dow="monday",
            maintenance_window_time="04:00:00",
            flink_user_config={
                "custom_code": True,
            })
        example_flink_jar_application = aiven.FlinkJarApplication("example",
            project=example.project,
            service_name=example.service_name,
            name="example-app-jar")
        example_flink_jar_application_version = aiven.FlinkJarApplicationVersion("example",
            project=example.project,
            service_name=example.service_name,
            application_id=example_flink_jar_application.application_id,
            source="./example.jar")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/flinkJarApplicationVersion:FlinkJarApplicationVersion example PROJECT/SERVICE_NAME/APPLICATION_ID/APPLICATION_VERSION_ID
        ```

        :param str resource_name: The name of the resource.
        :param FlinkJarApplicationVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkJarApplicationVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkJarApplicationVersionArgs.__new__(FlinkJarApplicationVersionArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["application_version_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["file_infos"] = None
            __props__.__dict__["source_checksum"] = None
            __props__.__dict__["version"] = None
        super(FlinkJarApplicationVersion, __self__).__init__(
            'aiven:index/flinkJarApplicationVersion:FlinkJarApplicationVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            application_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            file_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlinkJarApplicationVersionFileInfoArgs', 'FlinkJarApplicationVersionFileInfoArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_checksum: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'FlinkJarApplicationVersion':
        """
        Get an existing FlinkJarApplicationVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] application_version_id: ApplicationVersion ID.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] created_by: The creator of this entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlinkJarApplicationVersionFileInfoArgs', 'FlinkJarApplicationVersionFileInfoArgsDict']]]] file_infos: Flink JarApplicationVersion FileInfo.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source: The path to the jar file to upload.
        :param pulumi.Input[_builtins.str] source_checksum: The sha256 checksum of the jar file to upload.
        :param pulumi.Input[_builtins.int] version: Version number.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkJarApplicationVersionState.__new__(_FlinkJarApplicationVersionState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_version_id"] = application_version_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["file_infos"] = file_infos
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["source"] = source
        __props__.__dict__["source_checksum"] = source_checksum
        __props__.__dict__["version"] = version
        return FlinkJarApplicationVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        Application Id. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationVersionId")
    def application_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        ApplicationVersion ID.
        """
        return pulumi.get(self, "application_version_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The creator of this entity.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="fileInfos")
    def file_infos(self) -> pulumi.Output[Sequence['outputs.FlinkJarApplicationVersionFileInfo']]:
        """
        Flink JarApplicationVersion FileInfo.
        """
        return pulumi.get(self, "file_infos")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the jar file to upload.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceChecksum")
    def source_checksum(self) -> pulumi.Output[_builtins.str]:
        """
        The sha256 checksum of the jar file to upload.
        """
        return pulumi.get(self, "source_checksum")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        Version number.
        """
        return pulumi.get(self, "version")

