# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrganizationBillingGroupResult',
    'AwaitableGetOrganizationBillingGroupResult',
    'get_organization_billing_group',
    'get_organization_billing_group_output',
]

@pulumi.output_type
class GetOrganizationBillingGroupResult:
    """
    A collection of values returned by getOrganizationBillingGroup.
    """
    def __init__(__self__, billing_address_id=None, billing_contact_emails=None, billing_emails=None, billing_group_id=None, billing_group_name=None, currency=None, custom_invoice_text=None, id=None, organization_id=None, payment_method_id=None, shipping_address_id=None, timeouts=None, vat_id=None):
        if billing_address_id and not isinstance(billing_address_id, str):
            raise TypeError("Expected argument 'billing_address_id' to be a str")
        pulumi.set(__self__, "billing_address_id", billing_address_id)
        if billing_contact_emails and not isinstance(billing_contact_emails, list):
            raise TypeError("Expected argument 'billing_contact_emails' to be a list")
        pulumi.set(__self__, "billing_contact_emails", billing_contact_emails)
        if billing_emails and not isinstance(billing_emails, list):
            raise TypeError("Expected argument 'billing_emails' to be a list")
        pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_group_id and not isinstance(billing_group_id, str):
            raise TypeError("Expected argument 'billing_group_id' to be a str")
        pulumi.set(__self__, "billing_group_id", billing_group_id)
        if billing_group_name and not isinstance(billing_group_name, str):
            raise TypeError("Expected argument 'billing_group_name' to be a str")
        pulumi.set(__self__, "billing_group_name", billing_group_name)
        if currency and not isinstance(currency, str):
            raise TypeError("Expected argument 'currency' to be a str")
        pulumi.set(__self__, "currency", currency)
        if custom_invoice_text and not isinstance(custom_invoice_text, str):
            raise TypeError("Expected argument 'custom_invoice_text' to be a str")
        pulumi.set(__self__, "custom_invoice_text", custom_invoice_text)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if payment_method_id and not isinstance(payment_method_id, str):
            raise TypeError("Expected argument 'payment_method_id' to be a str")
        pulumi.set(__self__, "payment_method_id", payment_method_id)
        if shipping_address_id and not isinstance(shipping_address_id, str):
            raise TypeError("Expected argument 'shipping_address_id' to be a str")
        pulumi.set(__self__, "shipping_address_id", shipping_address_id)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)
        if vat_id and not isinstance(vat_id, str):
            raise TypeError("Expected argument 'vat_id' to be a str")
        pulumi.set(__self__, "vat_id", vat_id)

    @_builtins.property
    @pulumi.getter(name="billingAddressId")
    def billing_address_id(self) -> _builtins.str:
        """
        Billing address ID.
        """
        return pulumi.get(self, "billing_address_id")

    @_builtins.property
    @pulumi.getter(name="billingContactEmails")
    def billing_contact_emails(self) -> Sequence[_builtins.str]:
        """
        List of billing contact emails.
        """
        return pulumi.get(self, "billing_contact_emails")

    @_builtins.property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Sequence[_builtins.str]:
        """
        List of billing contact emails.
        """
        return pulumi.get(self, "billing_emails")

    @_builtins.property
    @pulumi.getter(name="billingGroupId")
    def billing_group_id(self) -> _builtins.str:
        """
        Billing group ID.
        """
        return pulumi.get(self, "billing_group_id")

    @_builtins.property
    @pulumi.getter(name="billingGroupName")
    def billing_group_name(self) -> _builtins.str:
        """
        Billing Group Name.
        """
        return pulumi.get(self, "billing_group_name")

    @_builtins.property
    @pulumi.getter
    def currency(self) -> _builtins.str:
        """
        Acceptable currencies for a billing group. The possible values are `AUD`, `CAD`, `CHF`, `DKK`, `EUR`, `GBP`, `JPY`, `NOK`, `NZD`, `SEK`, `SGD` and `USD`.
        """
        return pulumi.get(self, "currency")

    @_builtins.property
    @pulumi.getter(name="customInvoiceText")
    def custom_invoice_text(self) -> _builtins.str:
        """
        Extra billing text.
        """
        return pulumi.get(self, "custom_invoice_text")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Resource ID, a composite of `organization_id` and `billing_group_id` IDs.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        ID of an organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="paymentMethodId")
    def payment_method_id(self) -> _builtins.str:
        """
        Payment method ID.
        """
        return pulumi.get(self, "payment_method_id")

    @_builtins.property
    @pulumi.getter(name="shippingAddressId")
    def shipping_address_id(self) -> _builtins.str:
        """
        Shipping address ID.
        """
        return pulumi.get(self, "shipping_address_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetOrganizationBillingGroupTimeoutsResult']:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> _builtins.str:
        """
        VAT ID.
        """
        return pulumi.get(self, "vat_id")


class AwaitableGetOrganizationBillingGroupResult(GetOrganizationBillingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationBillingGroupResult(
            billing_address_id=self.billing_address_id,
            billing_contact_emails=self.billing_contact_emails,
            billing_emails=self.billing_emails,
            billing_group_id=self.billing_group_id,
            billing_group_name=self.billing_group_name,
            currency=self.currency,
            custom_invoice_text=self.custom_invoice_text,
            id=self.id,
            organization_id=self.organization_id,
            payment_method_id=self.payment_method_id,
            shipping_address_id=self.shipping_address_id,
            timeouts=self.timeouts,
            vat_id=self.vat_id)


def get_organization_billing_group(billing_group_id: Optional[_builtins.str] = None,
                                   organization_id: Optional[_builtins.str] = None,
                                   timeouts: Optional[Union['GetOrganizationBillingGroupTimeoutsArgs', 'GetOrganizationBillingGroupTimeoutsArgsDict']] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationBillingGroupResult:
    """
    Gets information about a billing group.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str billing_group_id: Billing group ID.
    :param _builtins.str organization_id: ID of an organization.
    """
    __args__ = dict()
    __args__['billingGroupId'] = billing_group_id
    __args__['organizationId'] = organization_id
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOrganizationBillingGroup:getOrganizationBillingGroup', __args__, opts=opts, typ=GetOrganizationBillingGroupResult).value

    return AwaitableGetOrganizationBillingGroupResult(
        billing_address_id=pulumi.get(__ret__, 'billing_address_id'),
        billing_contact_emails=pulumi.get(__ret__, 'billing_contact_emails'),
        billing_emails=pulumi.get(__ret__, 'billing_emails'),
        billing_group_id=pulumi.get(__ret__, 'billing_group_id'),
        billing_group_name=pulumi.get(__ret__, 'billing_group_name'),
        currency=pulumi.get(__ret__, 'currency'),
        custom_invoice_text=pulumi.get(__ret__, 'custom_invoice_text'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        payment_method_id=pulumi.get(__ret__, 'payment_method_id'),
        shipping_address_id=pulumi.get(__ret__, 'shipping_address_id'),
        timeouts=pulumi.get(__ret__, 'timeouts'),
        vat_id=pulumi.get(__ret__, 'vat_id'))
def get_organization_billing_group_output(billing_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          timeouts: Optional[pulumi.Input[Optional[Union['GetOrganizationBillingGroupTimeoutsArgs', 'GetOrganizationBillingGroupTimeoutsArgsDict']]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationBillingGroupResult]:
    """
    Gets information about a billing group.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str billing_group_id: Billing group ID.
    :param _builtins.str organization_id: ID of an organization.
    """
    __args__ = dict()
    __args__['billingGroupId'] = billing_group_id
    __args__['organizationId'] = organization_id
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOrganizationBillingGroup:getOrganizationBillingGroup', __args__, opts=opts, typ=GetOrganizationBillingGroupResult)
    return __ret__.apply(lambda __response__: GetOrganizationBillingGroupResult(
        billing_address_id=pulumi.get(__response__, 'billing_address_id'),
        billing_contact_emails=pulumi.get(__response__, 'billing_contact_emails'),
        billing_emails=pulumi.get(__response__, 'billing_emails'),
        billing_group_id=pulumi.get(__response__, 'billing_group_id'),
        billing_group_name=pulumi.get(__response__, 'billing_group_name'),
        currency=pulumi.get(__response__, 'currency'),
        custom_invoice_text=pulumi.get(__response__, 'custom_invoice_text'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        payment_method_id=pulumi.get(__response__, 'payment_method_id'),
        shipping_address_id=pulumi.get(__response__, 'shipping_address_id'),
        timeouts=pulumi.get(__response__, 'timeouts'),
        vat_id=pulumi.get(__response__, 'vat_id')))
