# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, account_id=None, add_account_owners_admin_access=None, available_credits=None, billing_group=None, ca_cert=None, copy_from_project=None, default_cloud=None, estimated_balance=None, id=None, parent_id=None, payment_method=None, project=None, tags=None, technical_emails=None, use_source_project_billing_group=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if add_account_owners_admin_access and not isinstance(add_account_owners_admin_access, bool):
            raise TypeError("Expected argument 'add_account_owners_admin_access' to be a bool")
        pulumi.set(__self__, "add_account_owners_admin_access", add_account_owners_admin_access)
        if available_credits and not isinstance(available_credits, str):
            raise TypeError("Expected argument 'available_credits' to be a str")
        pulumi.set(__self__, "available_credits", available_credits)
        if billing_group and not isinstance(billing_group, str):
            raise TypeError("Expected argument 'billing_group' to be a str")
        pulumi.set(__self__, "billing_group", billing_group)
        if ca_cert and not isinstance(ca_cert, str):
            raise TypeError("Expected argument 'ca_cert' to be a str")
        pulumi.set(__self__, "ca_cert", ca_cert)
        if copy_from_project and not isinstance(copy_from_project, str):
            raise TypeError("Expected argument 'copy_from_project' to be a str")
        pulumi.set(__self__, "copy_from_project", copy_from_project)
        if default_cloud and not isinstance(default_cloud, str):
            raise TypeError("Expected argument 'default_cloud' to be a str")
        pulumi.set(__self__, "default_cloud", default_cloud)
        if estimated_balance and not isinstance(estimated_balance, str):
            raise TypeError("Expected argument 'estimated_balance' to be a str")
        pulumi.set(__self__, "estimated_balance", estimated_balance)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if payment_method and not isinstance(payment_method, str):
            raise TypeError("Expected argument 'payment_method' to be a str")
        pulumi.set(__self__, "payment_method", payment_method)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if technical_emails and not isinstance(technical_emails, list):
            raise TypeError("Expected argument 'technical_emails' to be a list")
        pulumi.set(__self__, "technical_emails", technical_emails)
        if use_source_project_billing_group and not isinstance(use_source_project_billing_group, bool):
            raise TypeError("Expected argument 'use_source_project_billing_group' to be a bool")
        pulumi.set(__self__, "use_source_project_billing_group", use_source_project_billing_group)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="addAccountOwnersAdminAccess")
    def add_account_owners_admin_access(self) -> _builtins.bool:
        """
        If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        """
        return pulumi.get(self, "add_account_owners_admin_access")

    @_builtins.property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> _builtins.str:
        """
        The number of trial or promotional credits remaining for this project.
        """
        return pulumi.get(self, "available_credits")

    @_builtins.property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> _builtins.str:
        """
        The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> _builtins.str:
        """
        The CA certificate for the project. This is required for configuring clients that connect to certain services like Kafka.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> _builtins.str:
        """
        The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "copy_from_project")

    @_builtins.property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> _builtins.str:
        """
        Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        """
        return pulumi.get(self, "default_cloud")

    @_builtins.property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> _builtins.str:
        """
        The monthly running estimate for this project for the current billing period.
        """
        return pulumi.get(self, "estimated_balance")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> _builtins.str:
        """
        The payment type used for this project. For example,`card`.
        """
        return pulumi.get(self, "payment_method")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetProjectTagResult']:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Sequence[_builtins.str]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @_builtins.property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    def use_source_project_billing_group(self) -> _builtins.bool:
        """
        Use the same billing group that is used in source project.
        """
        return pulumi.get(self, "use_source_project_billing_group")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            account_id=self.account_id,
            add_account_owners_admin_access=self.add_account_owners_admin_access,
            available_credits=self.available_credits,
            billing_group=self.billing_group,
            ca_cert=self.ca_cert,
            copy_from_project=self.copy_from_project,
            default_cloud=self.default_cloud,
            estimated_balance=self.estimated_balance,
            id=self.id,
            parent_id=self.parent_id,
            payment_method=self.payment_method,
            project=self.project,
            tags=self.tags,
            technical_emails=self.technical_emails,
            use_source_project_billing_group=self.use_source_project_billing_group)


def get_project(project: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Gets information about an Aiven project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_project = aiven.get_project(project="example-project")
    ```


    :param _builtins.str project: The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        add_account_owners_admin_access=pulumi.get(__ret__, 'add_account_owners_admin_access'),
        available_credits=pulumi.get(__ret__, 'available_credits'),
        billing_group=pulumi.get(__ret__, 'billing_group'),
        ca_cert=pulumi.get(__ret__, 'ca_cert'),
        copy_from_project=pulumi.get(__ret__, 'copy_from_project'),
        default_cloud=pulumi.get(__ret__, 'default_cloud'),
        estimated_balance=pulumi.get(__ret__, 'estimated_balance'),
        id=pulumi.get(__ret__, 'id'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        payment_method=pulumi.get(__ret__, 'payment_method'),
        project=pulumi.get(__ret__, 'project'),
        tags=pulumi.get(__ret__, 'tags'),
        technical_emails=pulumi.get(__ret__, 'technical_emails'),
        use_source_project_billing_group=pulumi.get(__ret__, 'use_source_project_billing_group'))
def get_project_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Gets information about an Aiven project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_project = aiven.get_project(project="example-project")
    ```


    :param _builtins.str project: The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        account_id=pulumi.get(__response__, 'account_id'),
        add_account_owners_admin_access=pulumi.get(__response__, 'add_account_owners_admin_access'),
        available_credits=pulumi.get(__response__, 'available_credits'),
        billing_group=pulumi.get(__response__, 'billing_group'),
        ca_cert=pulumi.get(__response__, 'ca_cert'),
        copy_from_project=pulumi.get(__response__, 'copy_from_project'),
        default_cloud=pulumi.get(__response__, 'default_cloud'),
        estimated_balance=pulumi.get(__response__, 'estimated_balance'),
        id=pulumi.get(__response__, 'id'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        payment_method=pulumi.get(__response__, 'payment_method'),
        project=pulumi.get(__response__, 'project'),
        tags=pulumi.get(__response__, 'tags'),
        technical_emails=pulumi.get(__response__, 'technical_emails'),
        use_source_project_billing_group=pulumi.get(__response__, 'use_source_project_billing_group')))
