# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GovernanceAccessArgs', 'GovernanceAccess']

@pulumi.input_type
class GovernanceAccessArgs:
    def __init__(__self__, *,
                 access_name: pulumi.Input[_builtins.str],
                 access_type: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 access_data: Optional[pulumi.Input['GovernanceAccessAccessDataArgs']] = None,
                 owner_user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['GovernanceAccessTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a GovernanceAccess resource.
        :param pulumi.Input[_builtins.str] access_name: Label to describe the access. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_type: An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input['GovernanceAccessAccessDataArgs'] access_data: Required property. access type specific data. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] owner_user_group_id: The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "access_name", access_name)
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "organization_id", organization_id)
        if access_data is not None:
            pulumi.set(__self__, "access_data", access_data)
        if owner_user_group_id is not None:
            pulumi.set(__self__, "owner_user_group_id", owner_user_group_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="accessName")
    def access_name(self) -> pulumi.Input[_builtins.str]:
        """
        Label to describe the access. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_name")

    @access_name.setter
    def access_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_name", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Input[_builtins.str]:
        """
        An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="accessData")
    def access_data(self) -> Optional[pulumi.Input['GovernanceAccessAccessDataArgs']]:
        """
        Required property. access type specific data. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_data")

    @access_data.setter
    def access_data(self, value: Optional[pulumi.Input['GovernanceAccessAccessDataArgs']]):
        pulumi.set(self, "access_data", value)

    @_builtins.property
    @pulumi.getter(name="ownerUserGroupId")
    def owner_user_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "owner_user_group_id")

    @owner_user_group_id.setter
    def owner_user_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_user_group_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GovernanceAccessTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GovernanceAccessTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _GovernanceAccessState:
    def __init__(__self__, *,
                 access_data: Optional[pulumi.Input['GovernanceAccessAccessDataArgs']] = None,
                 access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 susbcription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['GovernanceAccessTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering GovernanceAccess resources.
        :param pulumi.Input['GovernanceAccessAccessDataArgs'] access_data: Required property. access type specific data. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_name: Label to describe the access. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_type: An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] owner_user_group_id: The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] susbcription_id: The ID of the access.
        """
        if access_data is not None:
            pulumi.set(__self__, "access_data", access_data)
        if access_name is not None:
            pulumi.set(__self__, "access_name", access_name)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if owner_user_group_id is not None:
            pulumi.set(__self__, "owner_user_group_id", owner_user_group_id)
        if susbcription_id is not None:
            pulumi.set(__self__, "susbcription_id", susbcription_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="accessData")
    def access_data(self) -> Optional[pulumi.Input['GovernanceAccessAccessDataArgs']]:
        """
        Required property. access type specific data. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_data")

    @access_data.setter
    def access_data(self, value: Optional[pulumi.Input['GovernanceAccessAccessDataArgs']]):
        pulumi.set(self, "access_data", value)

    @_builtins.property
    @pulumi.getter(name="accessName")
    def access_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Label to describe the access. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_name")

    @access_name.setter
    def access_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_name", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="ownerUserGroupId")
    def owner_user_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "owner_user_group_id")

    @owner_user_group_id.setter
    def owner_user_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_user_group_id", value)

    @_builtins.property
    @pulumi.getter(name="susbcriptionId")
    def susbcription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the access.
        """
        return pulumi.get(self, "susbcription_id")

    @susbcription_id.setter
    def susbcription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "susbcription_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GovernanceAccessTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GovernanceAccessTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aiven:index/governanceAccess:GovernanceAccess")
class GovernanceAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_data: Optional[pulumi.Input[Union['GovernanceAccessAccessDataArgs', 'GovernanceAccessAccessDataArgsDict']]] = None,
                 access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['GovernanceAccessTimeoutsArgs', 'GovernanceAccessTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_access = aiven.GovernanceAccess("example_access",
            organization_id=main["id"],
            access_name="example-topic-access",
            access_type="KAFKA",
            access_data={
                "project": example_project["project"],
                "service_name": example_kafka["serviceName"],
                "acls": [{
                    "resource_name": "example-topic",
                    "resource_type": "Topic",
                    "operation": "Read",
                    "permission_type": "ALLOW",
                    "host": "*",
                }],
            },
            owner_user_group_id=example["groupId"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GovernanceAccessAccessDataArgs', 'GovernanceAccessAccessDataArgsDict']] access_data: Required property. access type specific data. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_name: Label to describe the access. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_type: An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] owner_user_group_id: The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GovernanceAccessArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_access = aiven.GovernanceAccess("example_access",
            organization_id=main["id"],
            access_name="example-topic-access",
            access_type="KAFKA",
            access_data={
                "project": example_project["project"],
                "service_name": example_kafka["serviceName"],
                "acls": [{
                    "resource_name": "example-topic",
                    "resource_type": "Topic",
                    "operation": "Read",
                    "permission_type": "ALLOW",
                    "host": "*",
                }],
            },
            owner_user_group_id=example["groupId"])
        ```

        :param str resource_name: The name of the resource.
        :param GovernanceAccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GovernanceAccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_data: Optional[pulumi.Input[Union['GovernanceAccessAccessDataArgs', 'GovernanceAccessAccessDataArgsDict']]] = None,
                 access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['GovernanceAccessTimeoutsArgs', 'GovernanceAccessTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GovernanceAccessArgs.__new__(GovernanceAccessArgs)

            __props__.__dict__["access_data"] = access_data
            if access_name is None and not opts.urn:
                raise TypeError("Missing required property 'access_name'")
            __props__.__dict__["access_name"] = access_name
            if access_type is None and not opts.urn:
                raise TypeError("Missing required property 'access_type'")
            __props__.__dict__["access_type"] = access_type
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["owner_user_group_id"] = owner_user_group_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["susbcription_id"] = None
        super(GovernanceAccess, __self__).__init__(
            'aiven:index/governanceAccess:GovernanceAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_data: Optional[pulumi.Input[Union['GovernanceAccessAccessDataArgs', 'GovernanceAccessAccessDataArgsDict']]] = None,
            access_name: Optional[pulumi.Input[_builtins.str]] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            owner_user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            susbcription_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['GovernanceAccessTimeoutsArgs', 'GovernanceAccessTimeoutsArgsDict']]] = None) -> 'GovernanceAccess':
        """
        Get an existing GovernanceAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GovernanceAccessAccessDataArgs', 'GovernanceAccessAccessDataArgsDict']] access_data: Required property. access type specific data. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_name: Label to describe the access. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] access_type: An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] owner_user_group_id: The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] susbcription_id: The ID of the access.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GovernanceAccessState.__new__(_GovernanceAccessState)

        __props__.__dict__["access_data"] = access_data
        __props__.__dict__["access_name"] = access_name
        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["owner_user_group_id"] = owner_user_group_id
        __props__.__dict__["susbcription_id"] = susbcription_id
        __props__.__dict__["timeouts"] = timeouts
        return GovernanceAccess(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessData")
    def access_data(self) -> pulumi.Output[Optional['outputs.GovernanceAccessAccessData']]:
        """
        Required property. access type specific data. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_data")

    @_builtins.property
    @pulumi.getter(name="accessName")
    def access_name(self) -> pulumi.Output[_builtins.str]:
        """
        Label to describe the access. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_name")

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[_builtins.str]:
        """
        An enumeration. The possible value is `KAFKA`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an organization. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="ownerUserGroupId")
    def owner_user_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the group that will own the access. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "owner_user_group_id")

    @_builtins.property
    @pulumi.getter(name="susbcriptionId")
    def susbcription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the access.
        """
        return pulumi.get(self, "susbcription_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.GovernanceAccessTimeouts']]:
        return pulumi.get(self, "timeouts")

