"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationStackArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const cloud_artifact_1 = require("../cloud-artifact");
const environment_1 = require("../environment");
const CLOUDFORMATION_STACK_ARTIFACT_SYM = Symbol.for('@aws-cdk/cx-api.CloudFormationStackArtifact');
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * Checks if `art` is an instance of this class.
     *
     * Use this method instead of `instanceof` to properly detect `CloudFormationStackArtifact`
     * instances, even when the construct library is symlinked.
     *
     * Explanation: in JavaScript, multiple copies of the `cx-api` library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class `CloudFormationStackArtifact` in each copy of the `cx-api` library
     * is seen as a different class, and an instance of one class will not test as
     * `instanceof` the other class. `npm install` will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the `cx-api`
     * library can be accidentally installed, and `instanceof` will behave
     * unpredictably. It is safest to avoid using `instanceof`, and using
     * this type-testing method instead.
     */
    static isCloudFormationStackArtifact(art) {
        return art && typeof art === 'object' && art[CLOUDFORMATION_STACK_ARTIFACT_SYM];
    }
    constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationStackArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.templateFile) {
            throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
            throw new Error('Invalid CloudFormation stack artifact. Missing environment');
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters ?? {};
        // We get the tags from 'properties' if available (cloud assembly format >= 6.0.0), otherwise
        // from the stack metadata
        this.tags = properties.tags ?? this.tagsFromMetadata();
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.lookupRole = properties.lookupRole;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e => e.data);
        this.displayName = this.stackName === artifactId
            ? this.hierarchicalId
            : `${this.hierarchicalId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
    /**
     * Full path to the template file
     */
    get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
    }
    /**
     * The CloudFormation template for this stack.
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(this.templateFullPath, 'utf-8'));
        }
        return this._template;
    }
    tagsFromMetadata() {
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of (metadataEntry.data ?? [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationStackArtifact[_a] = { fqn: "@aws-cdk/cx-api.CloudFormationStackArtifact", version: "2.112.0" };
/**
 * Mark all instances of 'CloudFormationStackArtifact'
 *
 * Why not put this in the constructor? Because this is a class property,
 * not an instance property. It applies to all instances of the class.
 */
Object.defineProperty(CloudFormationStackArtifact.prototype, CLOUDFORMATION_STACK_ARTIFACT_SYM, {
    value: true,
    enumerable: false,
    writable: false,
});
//# sourceMappingURL=data:application/json;base64,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