"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeCloudArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_artifact_1 = require("../cloud-artifact");
const TREE_CLOUD_ARTIFACT_SYM = Symbol.for('@aws-cdk/cx-api.TreeCloudArtifact');
class TreeCloudArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * Checks if `art` is an instance of this class.
     *
     * Use this method instead of `instanceof` to properly detect `TreeCloudArtifact`
     * instances, even when the construct library is symlinked.
     *
     * Explanation: in JavaScript, multiple copies of the `cx-api` library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class `TreeCloudArtifact` in each copy of the `cx-api` library
     * is seen as a different class, and an instance of one class will not test as
     * `instanceof` the other class. `npm install` will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the `cx-api`
     * library can be accidentally installed, and `instanceof` will behave
     * unpredictably. It is safest to avoid using `instanceof`, and using
     * this type-testing method instead.
     */
    static isTreeCloudArtifact(art) {
        return art && typeof art === 'object' && art[TREE_CLOUD_ARTIFACT_SYM];
    }
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TreeCloudArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
    }
}
exports.TreeCloudArtifact = TreeCloudArtifact;
_a = JSII_RTTI_SYMBOL_1;
TreeCloudArtifact[_a] = { fqn: "@aws-cdk/cx-api.TreeCloudArtifact", version: "2.112.0" };
/**
 * Mark all instances of 'TreeCloudArtifact'
 *
 * Why not put this in the constructor? Because this is a class property,
 * not an instance property. It applies to all instances of the class.
 */
Object.defineProperty(TreeCloudArtifact.prototype, TREE_CLOUD_ARTIFACT_SYM, {
    value: true,
    enumerable: false,
    writable: false,
});
//# sourceMappingURL=data:application/json;base64,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