"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const asset_manifest_artifact_1 = require("./artifacts/asset-manifest-artifact");
const cloudformation_artifact_1 = require("./artifacts/cloudformation-artifact");
const nested_cloud_assembly_artifact_1 = require("./artifacts/nested-cloud-assembly-artifact");
const tree_cloud_artifact_1 = require("./artifacts/tree-cloud-artifact");
const cloud_artifact_1 = require("./cloud-artifact");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
/**
 * Add the 'fromManifest' factory function
 *
 * It is defined in a separate file to avoid circular dependencies between 'cloud-artifact.ts'
 * and all of its subclass files.
 */
cloud_artifact_1.CloudArtifact.fromManifest = function fromManifest(assembly, id, artifact) {
    switch (artifact.type) {
        case cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK:
            return new cloudformation_artifact_1.CloudFormationStackArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.CDK_TREE:
            return new tree_cloud_artifact_1.TreeCloudArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.ASSET_MANIFEST:
            return new asset_manifest_artifact_1.AssetManifestArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY:
            return new nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact(assembly, id, artifact);
        default:
            return undefined;
    }
};
//# sourceMappingURL=data:application/json;base64,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