"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY = exports.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE = exports.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID = exports.EFS_DENY_ANONYMOUS_ACCESS = exports.KMS_ALIAS_NAME_REF = exports.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = exports.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = exports.EC2_RESTRICT_DEFAULT_SECURITY_GROUP = exports.ENABLE_EMR_SERVICE_POLICY_V2 = exports.REDSHIFT_COLUMN_ID = exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = exports.ROUTE53_PATTERNS_USE_CERTIFICATE = exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS = exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = exports.ENABLE_PARTITION_LITERALS = exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = exports.S3_CREATE_DEFAULT_LOGGING_POLICY = exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = exports.IAM_MINIMIZE_POLICIES = exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = exports.TARGET_PARTITIONS = exports.CHECK_SECRET_USAGE = exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = exports.LAMBDA_RECOGNIZE_LAYER_VERSION = exports.LAMBDA_RECOGNIZE_VERSION_PROPS = exports.EFS_DEFAULT_ENCRYPTION_AT_REST = exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports.RDS_LOWERCASE_DB_IDENTIFIER = exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports.S3_GRANT_WRITE_WITHOUT_ACL = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
exports.NEW_PROJECT_DEFAULT_CONTEXT = exports.FUTURE_FLAGS = exports.FUTURE_FLAGS_EXPIRED = exports.futureFlagDefault = exports.CURRENT_VERSION_FLAG_DEFAULTS = exports.NEW_PROJECT_CONTEXT = exports.CURRENT_VERSION_EXPIRED_FLAGS = exports.FLAGS = exports.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME = exports.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION = exports.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = exports.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = exports.LAMBDA_NODEJS_USE_LATEST_RUNTIME = void 0;
const flag_modeling_1 = require("./private/flag-modeling");
////////////////////////////////////////////////////////////////////////
//
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file.
//
////////////////////////////////////////////////////////////////////////
//
//  !!! IMPORTANT !!!
//
//  When you introduce a new flag, set its 'introducedIn.v2' value to the literal string
// 'V2·NEXT', without the dot.
//
//  DO NOT USE A VARIABLE. DO NOT DEFINE A CONSTANT. The actual value will be string-replaced at
//  version bump time.
//
////////////////////////////////////////////////////////////////////////
//
// There are three types of flags: ApiDefault, BugFix, and VisibleContext flags.
//
// - ApiDefault flags: change the behavior or defaults of the construct library. When
//   set, the infrastructure that is generated may be different but there is
//   a way to get the old infrastructure setup by using the API in a different way.
//
// - BugFix flags: the old infra we used to generate is no longer recommended,
//   and there is no way to achieve that result anymore except by making sure the
//   flag is unset, or set to `false`. Mostly used for infra-impacting bugfixes or
//   enhanced security defaults.
//
// - VisibleContext flags: not really a feature flag, but configurable context which is
//   advertised by putting the context in the `cdk.json` file of new projects.
//
// In future major versions, the "newProjectValues" will become the version
// default for both DefaultBehavior and BugFix flags, and DefaultBehavior flags
// will be removed (i.e., their new behavior will become the *only* behavior).
//
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
exports.STACK_RELATIVE_EXPORTS_CONTEXT = '@aws-cdk/core:stackRelativeExports';
exports.DOCKER_IGNORE_SUPPORT = '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport';
exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = '@aws-cdk/aws-secretsmanager:parseOwnedSecretName';
exports.KMS_DEFAULT_KEY_POLICIES = '@aws-cdk/aws-kms:defaultKeyPolicies';
exports.S3_GRANT_WRITE_WITHOUT_ACL = '@aws-cdk/aws-s3:grantWriteWithoutAcl';
exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = '@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount';
exports.RDS_LOWERCASE_DB_IDENTIFIER = '@aws-cdk/aws-rds:lowercaseDbIdentifier';
exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = '@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId';
exports.EFS_DEFAULT_ENCRYPTION_AT_REST = '@aws-cdk/aws-efs:defaultEncryptionAtRest';
exports.LAMBDA_RECOGNIZE_VERSION_PROPS = '@aws-cdk/aws-lambda:recognizeVersionProps';
exports.LAMBDA_RECOGNIZE_LAYER_VERSION = '@aws-cdk/aws-lambda:recognizeLayerVersion';
exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = '@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021';
exports.CHECK_SECRET_USAGE = '@aws-cdk/core:checkSecretUsage';
exports.TARGET_PARTITIONS = '@aws-cdk/core:target-partitions';
exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = '@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver';
exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = '@aws-cdk/aws-ec2:uniqueImdsv2TemplateName';
exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = '@aws-cdk/aws-ecs:arnFormatIncludesClusterName';
exports.IAM_MINIMIZE_POLICIES = '@aws-cdk/aws-iam:minimizePolicies';
exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = '@aws-cdk/aws-iam:importedRoleStackSafeDefaultPolicyName';
exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = '@aws-cdk/core:validateSnapshotRemovalPolicy';
exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = '@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName';
exports.S3_CREATE_DEFAULT_LOGGING_POLICY = '@aws-cdk/aws-s3:createDefaultLoggingPolicy';
exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = '@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption';
exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = '@aws-cdk/aws-apigateway:disableCloudWatchRole';
exports.ENABLE_PARTITION_LITERALS = '@aws-cdk/core:enablePartitionLiterals';
exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = '@aws-cdk/aws-events:eventsTargetQueueSameAccount';
exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS = '@aws-cdk/aws-iam:standardizedServicePrincipals';
exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = '@aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker';
exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = '@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy';
exports.ROUTE53_PATTERNS_USE_CERTIFICATE = '@aws-cdk/aws-route53-patters:useCertificate';
exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = '@aws-cdk/customresources:installLatestAwsSdkDefault';
exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = '@aws-cdk/aws-rds:databaseProxyUniqueResourceName';
exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = '@aws-cdk/aws-codedeploy:removeAlarmsFromDeploymentGroup';
exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = '@aws-cdk/aws-apigateway:authorizerChangeDeploymentLogicalId';
exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = '@aws-cdk/aws-ec2:launchTemplateDefaultUserData';
exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = '@aws-cdk/aws-secretsmanager:useAttachedSecretResourcePolicyForSecretTargetAttachments';
exports.REDSHIFT_COLUMN_ID = '@aws-cdk/aws-redshift:columnId';
exports.ENABLE_EMR_SERVICE_POLICY_V2 = '@aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2';
exports.EC2_RESTRICT_DEFAULT_SECURITY_GROUP = '@aws-cdk/aws-ec2:restrictDefaultSecurityGroup';
exports.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = '@aws-cdk/aws-apigateway:requestValidatorUniqueId';
exports.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = '@aws-cdk/core:includePrefixInUniqueNameGeneration';
exports.KMS_ALIAS_NAME_REF = '@aws-cdk/aws-kms:aliasNameRef';
exports.EFS_DENY_ANONYMOUS_ACCESS = '@aws-cdk/aws-efs:denyAnonymousAccess';
exports.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID = '@aws-cdk/aws-efs:mountTargetOrderInsensitiveLogicalId';
exports.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE = '@aws-cdk/aws-autoscaling:generateLaunchTemplateInsteadOfLaunchConfig';
exports.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY = '@aws-cdk/aws-opensearchservice:enableOpensearchMultiAzWithStandby';
exports.LAMBDA_NODEJS_USE_LATEST_RUNTIME = '@aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion';
exports.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = '@aws-cdk/aws-rds:preventRenderingDeprecatedCredentials';
exports.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = '@aws-cdk/aws-rds:auroraClusterChangeScopeOfInstanceParameterGroupWithEachParameters';
exports.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION = '@aws-cdk/aws-appsync:useArnForSourceApiAssociationIdentifier';
exports.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME = '@aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource';
exports.FLAGS = {
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Allow multiple stacks with the same name',
        detailsMd: `
      If this is set, multiple stacks can use the same stack name (e.g. deployed to
      different environments). This means that the name of the synthesized template
      file will be based on the construct path and not on the defined \`stackName\`
      of the stack.`,
        recommendedValue: true,
        introducedIn: { v1: '1.16.0' },
        defaults: { v2: true },
        compatibilityWithOldBehaviorMd: 'Pass stack identifiers to the CLI instead of stack names.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Make `cdk diff` not fail when there are differences',
        detailsMd: `
      Determines what status code \`cdk diff\` should return when the specified stack
      differs from the deployed stack or the local CloudFormation template:

      * \`aws-cdk:enableDiffNoFail=true\` => status code == 0
      * \`aws-cdk:enableDiffNoFail=false\` => status code == 1

      You can override this behavior with the --fail flag:

      * \`--fail\` => status code == 1
      * \`--no-fail\` => status code == 0`,
        introducedIn: { v1: '1.19.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Specify `--fail` to the CLI.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Switch to new stack synthesis method which enables CI/CD',
        detailsMd: `
      If this flag is specified, all \`Stack\`s will use the \`DefaultStackSynthesizer\` by
      default. If it is not set, they will use the \`LegacyStackSynthesizer\`.`,
        introducedIn: { v1: '1.39.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Name exports based on the construct paths relative to the stack, rather than the global construct path',
        detailsMd: `
      Combined with the stack name this relative construct path is good enough to
      ensure uniqueness, and makes the export names robust against refactoring
      the location of the stack in the construct tree (specifically, moving the Stack
      into a Stage).`,
        introducedIn: { v1: '1.58.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.DOCKER_IGNORE_SUPPORT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'DockerImageAsset properly supports `.dockerignore` files by default',
        detailsMd: `
      If this flag is not set, the default behavior for \`DockerImageAsset\` is to use
      glob semantics for \`.dockerignore\` files. If this flag is set, the default behavior
      is standard Docker ignore semantics.

      This is a feature flag as the old behavior was technically incorrect but
      users may have come to depend on it.`,
        introducedIn: { v1: '1.73.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Update your `.dockerignore` file to match standard Docker ignore rules, if necessary.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Fix the referencing of SecretsManager names from ARNs',
        detailsMd: `
      Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
      rather than the default full resource name, which includes the SecretsManager suffix.

      If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
      used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).`,
        introducedIn: { v1: '1.77.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Use `parseArn(secret.secretName).resourceName` to emulate the incorrect old parsing.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.KMS_DEFAULT_KEY_POLICIES]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Tighten default KMS key policies',
        detailsMd: `
      KMS Keys start with a default key policy that grants the account access to administer the key,
      mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
      policy by specifying their own.

      If this flag is not set, the default key policy depends on the setting of the \`trustAccountIdentities\`
      flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
      resembles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
      true, the policy matches what happens when this feature flag is set.

      Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
      to the key's default policy (rather than replacing it).`,
        introducedIn: { v1: '1.78.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `trustAccountIdentities: false` to `Key` construct to restore the old behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_GRANT_WRITE_WITHOUT_ACL]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Remove `PutObjectAcl` from Bucket.grantWrite',
        detailsMd: `
      Change the old 's3:PutObject*' permission to 's3:PutObject' on Bucket,
      as the former includes 's3:PutObjectAcl',
      which could be used to grant read/write object access to IAM principals in other accounts.
      Use a feature flag to make sure existing customers who might be relying
      on the overly-broad permissions are not broken.`,
        introducedIn: { v1: '1.85.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Call `bucket.grantPutAcl()` in addition to `bucket.grantWrite()` to grant ACL permissions.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Do not specify a default DesiredCount for ECS services',
        detailsMd: `
      ApplicationLoadBalancedServiceBase, ApplicationMultipleTargetGroupServiceBase,
      NetworkLoadBalancedServiceBase, NetworkMultipleTargetGroupServiceBase, and
      QueueProcessingServiceBase currently determine a default value for the desired count of
      a CfnService if a desiredCount is not provided. The result of this is that on every
      deployment, the service count is reset to the fixed value, even if it was autoscaled.

      If this flag is not set, the default behaviour for CfnService.desiredCount is to set a
      desiredCount of 1, if one is not provided. If true, a default will not be defined for
      CfnService.desiredCount and as such desiredCount will be undefined, if one is not provided.`,
        introducedIn: { v1: '1.92.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'You can pass `desiredCount: 1` explicitly, but you should never need this.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.RDS_LOWERCASE_DB_IDENTIFIER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Force lowercasing of RDS Cluster names in CDK',
        detailsMd: `
      Cluster names must be lowercase, and the service will lowercase the name when the cluster
      is created. However, CDK did not use to know about this, and would use the user-provided name
      referencing the cluster, which would fail if it happened to be mixed-case.

      With this flag, lowercase the name in CDK so we can reference it properly.

      Must be behind a permanent flag because changing a name from mixed case to lowercase between deployments
      would lead CloudFormation to think the name was changed and would trigger a cluster replacement
      (losing data!).`,
        introducedIn: { v1: '1.97.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Allow adding/removing multiple UsagePlanKeys independently',
        detailsMd: `
      The UsagePlanKey resource connects an ApiKey with a UsagePlan. API Gateway does not allow more than one UsagePlanKey
      for any given UsagePlan and ApiKey combination. For this reason, CloudFormation cannot replace this resource without
      either the UsagePlan or ApiKey changing.

      The feature addition to support multiple UsagePlanKey resources - 142bd0e2 - recognized this and attempted to keep
      existing UsagePlanKey logical ids unchanged.
      However, this intentionally caused the logical id of the UsagePlanKey to be sensitive to order. That is, when
      the 'first' UsagePlanKey resource is removed, the logical id of the 'second' assumes what was originally the 'first',
      which again is disallowed.

      In effect, there is no way to get out of this mess in a backwards compatible way, while supporting existing stacks.
      This flag changes the logical id layout of UsagePlanKey to not be sensitive to order.`,
        introducedIn: { v1: '1.98.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enable this feature flag to have elastic file systems encrypted at rest by default.',
        detailsMd: `
      Encryption can also be configured explicitly using the \`encrypted\` property.
      `,
        introducedIn: { v1: '1.98.0' },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass the `encrypted: false` property to the `FileSystem` construct to disable encryption.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the  `fn.currentVersion`.',
        detailsMd: `
      The previous calculation incorrectly considered properties of the \`AWS::Lambda::Function\` resource that did
      not constitute creating a new Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: '1.106.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_RECOGNIZE_LAYER_VERSION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the `fn.currentVersion`.',
        detailsMd: `
      This flag correct incorporates Lambda Layer properties into the Lambda Function Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: '1.159.0', v2: '2.27.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to have cloudfront distributions use the security policy TLSv1.2_2021 by default.',
        detailsMd: `
      The security policy can also be configured explicitly using the \`minimumProtocolVersion\` property.`,
        introducedIn: { v1: '1.117.0', v2: '2.0.0' },
        defaults: { v2: true },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CHECK_SECRET_USAGE]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'Enable this flag to make it impossible to accidentally use SecretValues in unsafe locations',
        detailsMd: `
      With this flag enabled, \`SecretValue\` instances can only be passed to
      constructs that accept \`SecretValue\`s; otherwise, \`unsafeUnwrap()\` must be
      called to use it as a regular string.`,
        introducedIn: { v1: '1.153.0', v2: '2.21.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.TARGET_PARTITIONS]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'What regions to include in lookup tables of environment agnostic stacks',
        detailsMd: `
      Has no effect on stacks that have a defined region, but will limit the amount
      of unnecessary regions included in stacks without a known region.

      The type of this value should be a list of strings.`,
        introducedIn: { v1: '1.137.0', v2: '2.4.0' },
        recommendedValue: ['aws', 'aws-cn'],
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'ECS extensions will automatically add an `awslogs` driver if no logging is specified',
        detailsMd: `
      Enable this feature flag to configure default logging behavior for the ECS Service Extensions. This will enable the
      \`awslogs\` log driver for the application container of the service to send the container logs to CloudWatch Logs.

      This is a feature flag as the new behavior provides a better default experience for the users.`,
        introducedIn: { v1: '1.140.0', v2: '2.8.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Specify a log driver explicitly.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to have Launch Templates generated by the `InstanceRequireImdsv2Aspect` use unique names.',
        detailsMd: `
      Previously, the generated Launch Template names were only unique within a stack because they were based only on the
      \`Instance\` construct ID. If another stack that has an \`Instance\` with the same construct ID is deployed in the same
      account and region, the deployments would always fail as the generated Launch Template names were the same.

      The new implementation addresses this issue by generating the Launch Template name with the \`Names.uniqueId\` method.`,
        introducedIn: { v1: '1.140.0', v2: '2.8.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'ARN format used by ECS. In the new ARN format, the cluster name is part of the resource ID.',
        detailsMd: `
      If this flag is not set, the old ARN format (without cluster name) for ECS is used.
      If this flag is set, the new ARN format (with cluster name) for ECS is used.

      This is a feature flag as the old format is still valid for existing ECS clusters.

      See https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids
      `,
        introducedIn: { v2: '2.35.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_MINIMIZE_POLICIES]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: 'Minimize IAM policies by combining Statements',
        detailsMd: `
      Minimize IAM policies by combining Principals, Actions and Resources of two
      Statements in the policies, as long as it doesn't change the meaning of the
      policy.`,
        introducedIn: { v1: '1.150.0', v2: '2.18.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Error on snapshot removal policies on resources that do not support it.',
        detailsMd: `
      Makes sure we do not allow snapshot removal policy on resources that do not support it.
      If supplied on an unsupported resource, CloudFormation ignores the policy altogether.
      This flag will reduce confusion and unexpected loss of data when erroneously supplying
      the snapshot removal policy.`,
        introducedIn: { v2: '2.28.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'The old behavior was incorrect. Update your source to not specify SNAPSHOT policies on resources that do not support it.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate key aliases that include the stack name',
        detailsMd: `
      Enable this feature flag to have CodePipeline generate a unique cross account key alias name using the stack name.

      Previously, when creating multiple pipelines with similar naming conventions and when crossAccountKeys is true,
      the KMS key alias name created for these pipelines may be the same due to how the uniqueId is generated.

      This new implementation creates a stack safe resource name for the alias using the stack name instead of the stack ID.
      `,
        introducedIn: { v2: '2.29.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_CREATE_DEFAULT_LOGGING_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature flag to create an S3 bucket policy by default in cases where an AWS service would automatically create the Policy if one does not exist.',
        detailsMd: `
      For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
      that needs to be attached to the bucket. If you create the bucket without a policy and then add the
      bucket as the flow log destination, the service will automatically create the bucket policy with the
      necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
      and error indicating that a bucket policy already exists.

      In cases where we know what the required policy is we can go ahead and create the policy so we can
      remain in control of it.

      @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3
      `,
        introducedIn: { v2: '2.31.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Restrict KMS key policy for encrypted Queues a bit more',
        detailsMd: `
      Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
      only the topic which it is subscribed to and not the whole SNS service of an account.

      Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
      secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
      the subscribed queue.`,
        introducedIn: { v2: '2.32.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Make default CloudWatch Role behavior safe for multiple API Gateways in one environment',
        detailsMd: `
      Enable this feature flag to change the default behavior for aws-apigateway.RestApi and aws-apigateway.SpecRestApi
      to _not_ create a CloudWatch role and Account. There is only a single ApiGateway account per AWS
      environment which means that each time you create a RestApi in your account the ApiGateway account
      is overwritten. If at some point the newest RestApi is deleted, the ApiGateway Account and CloudWatch
      role will also be deleted, breaking any existing ApiGateways that were depending on them.

      When this flag is enabled you should either create the ApiGateway account and CloudWatch role
      separately _or_ only enable the cloudWatchRole on a single RestApi.
      `,
        introducedIn: { v2: '2.38.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_PARTITION_LITERALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Make ARNs concrete if AWS partition is known',
        // eslint-disable-next-line @aws-cdk/no-literal-partition
        detailsMd: `
      Enable this feature flag to get partition names as string literals in Stacks with known regions defined in
      their environment, such as "aws" or "aws-cn".  Previously the CloudFormation intrinsic function
      "Ref: AWS::Partition" was used.  For example:

      \`\`\`yaml
      Principal:
        AWS:
          Fn::Join:
            - ""
            - - "arn:"
              - Ref: AWS::Partition
              - :iam::123456789876:root
      \`\`\`

      becomes:

      \`\`\`yaml
      Principal:
        AWS: "arn:aws:iam::123456789876:root"
      \`\`\`

      The intrinsic function will still be used in Stacks where no region is defined or the region's partition
      is unknown.
      `,
        introducedIn: { v2: '2.38.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EVENTS_TARGET_QUEUE_SAME_ACCOUNT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Event Rules may only push to encrypted SQS queues in the same account',
        detailsMd: `
      This flag applies to SQS Queues that are used as the target of event Rules. When enabled, only principals
      from the same account as the Rule can send messages. If a queue is unencrypted, this restriction will
      always apply, regardless of the value of this flag.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_STANDARDIZED_SERVICE_PRINCIPALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use standardized (global) service principals everywhere',
        detailsMd: `
      We used to maintain a database of exceptions to Service Principal names in various regions. This database
      is no longer necessary: all service principals names have been standardized to their global form (\`SERVICE.amazonaws.com\`).

      This flag disables use of that exceptions database and always uses the global service principal.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Avoid setting the "ECS" deployment controller when adding a circuit breaker',
        detailsMd: `
      Enable this feature flag to avoid setting the "ECS" deployment controller when adding a circuit breaker to an
      ECS Service, as this will trigger a full replacement which fails to deploy when using set service names.
      This does not change any behaviour as the default deployment controller when it is not defined is ECS.

      This is a feature flag as the new behavior provides a better default experience for the users.
      `,
        introducedIn: { v2: '2.51.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable this feature to by default create default policy names for imported roles that depend on the stack the role is in.',
        detailsMd: `
      Without this, importing the same role in multiple places could lead to the permissions given for one version of the imported role
      to overwrite permissions given to the role at a different place where it was imported. This was due to all imported instances
      of a role using the same default policy name.

      This new implementation creates default policy names based on the constructs node path in their stack.
      `,
        introducedIn: { v2: '2.60.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use S3 Bucket Policy instead of ACLs for Server Access Logging',
        detailsMd: `
      Enable this feature flag to use S3 Bucket Policy for granting permission fo Server Access Logging
      rather than using the canned \`LogDeliveryWrite\` ACL. ACLs do not work when Object Ownership is
      enabled on the bucket.

      This flag uses a Bucket Policy statement to allow Server Access Log delivery, following best
      practices for S3.

      @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html
    `,
        introducedIn: { v2: '2.60.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ROUTE53_PATTERNS_USE_CERTIFICATE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Use the official `Certificate` resource instead of `DnsValidatedCertificate`',
        detailsMd: `
      Enable this feature flag to use the official CloudFormation supported \`Certificate\` resource instead
      of the deprecated \`DnsValidatedCertificate\` construct. If this flag is enabled and you are creating
      the stack in a region other than us-east-1 then you must also set \`crossRegionReferences=true\` on the
      stack.
      `,
        introducedIn: { v2: '2.61.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Define a `DnsValidatedCertificate` explicitly and pass in the `certificate` property',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Whether to install the latest SDK by default in AwsCustomResource',
        detailsMd: `
      This was originally introduced and enabled by default to not be limited by the SDK version
      that's installed on AWS Lambda. However, it creates issues for Lambdas bound to VPCs that
      do not have internet access, or in environments where 'npmjs.com' is not available.

      The recommended setting is to disable the default installation behavior, and pass the
      flag on a resource-by-resource basis to enable it if necessary.
    `,
        compatibilityWithOldBehaviorMd: 'Set installLatestAwsSdk: true on all resources that need it.',
        introducedIn: { v2: '2.60.0' },
        recommendedValue: false,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.DATABASE_PROXY_UNIQUE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Use unique resource name for Database Proxy',
        detailsMd: `
      If this flag is not set, the default behavior for \`DatabaseProxy\` is
      to use \`id\` of the constructor for \`dbProxyName\` when it's not specified in the argument.
      In this case, users can't deploy \`DatabaseProxy\`s that have the same \`id\` in the same region.

      If this flag is set, the default behavior is to use unique resource names for each \`DatabaseProxy\`.

      This is a feature flag as the old behavior was technically incorrect, but users may have come to depend on it.
    `,
        introducedIn: { v2: '2.65.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Remove CloudWatch alarms from deployment group',
        detailsMd: `
      Enable this flag to be able to remove all CloudWatch alarms from a deployment group by removing
      the alarms from the construct. If this flag is not set, removing all alarms from the construct
      will still leave the alarms configured for the deployment group.
    `,
        introducedIn: { v2: '2.65.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Include authorizer configuration in the calculation of the API deployment logical ID.',
        detailsMd: `
      The logical ID of the AWS::ApiGateway::Deployment resource is calculated by hashing
      the API configuration, including methods, and resources, etc. Enable this feature flag
      to also include the configuration of any authorizer attached to the API in the
      calculation, so any changes made to an authorizer will create a new deployment.
      `,
        introducedIn: { v2: '2.66.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Define user data for a launch template by default when a machine image is provided.',
        detailsMd: `
      The ec2.LaunchTemplate construct did not define user data when a machine image is
      provided despite the document. If this is set, a user data is automatically defined
      according to the OS of the machine image.
      `,
        recommendedValue: true,
        introducedIn: { v2: '2.67.0' },
    },
    //////////////////////////////////////////////////////////////////////
    [exports.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'SecretTargetAttachments uses the ResourcePolicy of the attached Secret.',
        detailsMd: `
      Enable this feature flag to make SecretTargetAttachments use the ResourcePolicy of the attached Secret.
      SecretTargetAttachments are created to connect a Secret to a target resource.
      In CDK code, they behave like regular Secret and can be used as a stand-in in most situations.
      Previously, adding to the ResourcePolicy of a SecretTargetAttachment did attempt to create a separate ResourcePolicy for the same Secret.
      However Secrets can only have a single ResourcePolicy, causing the CloudFormation deployment to fail.

      When enabling this feature flag for an existing Stack, ResourcePolicies created via a SecretTargetAttachment will need replacement.
      This won't be possible without intervention due to limitation outlined above.
      First remove all permissions granted to the Secret and deploy without the ResourcePolicies.
      Then you can re-add the permissions and deploy again.
      `,
        recommendedValue: true,
        introducedIn: { v2: '2.67.0' },
    },
    //////////////////////////////////////////////////////////////////////
    [exports.REDSHIFT_COLUMN_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Whether to use an ID to track Redshift column changes',
        detailsMd: `
      Redshift columns are identified by their \`name\`. If a column is renamed, the old column
      will be dropped and a new column will be created. This can cause data loss.

      This flag enables the use of an \`id\` attribute for Redshift columns. If this flag is enabled, the
      internal CDK architecture will track changes of Redshift columns through their \`id\`, rather
      than their \`name\`. This will prevent data loss when columns are renamed.

      **NOTE** - Enabling this flag comes at a **risk**. When enabled, update the \`id\`s of all columns,
      **however** do not change the \`names\`s of the columns. If the \`name\`s of the columns are changed during
      initial deployment, the columns will be dropped and recreated, causing data loss. After the initial deployment
      of the \`id\`s, the \`name\`s of the columns can be changed without data loss.
      `,
        introducedIn: { v2: '2.68.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_EMR_SERVICE_POLICY_V2]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Enable AmazonEMRServicePolicy_v2 managed policies',
        detailsMd: `
      If this flag is not set, the default behavior for \`EmrCreateCluster\` is
      to use \`AmazonElasticMapReduceRole\` managed policies.

      If this flag is set, the default behavior is to use the new \`AmazonEMRServicePolicy_v2\`
      managed policies.

      This is a feature flag as the old behavior will be deprecated, but some resources may require manual
      intervention since they might not have the appropriate tags propagated automatically.
      `,
        introducedIn: { v2: '2.72.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EC2_RESTRICT_DEFAULT_SECURITY_GROUP]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Restrict access to the VPC default security group',
        detailsMd: `
      Enable this feature flag to remove the default ingress/egress rules from the
      VPC default security group.

      When a VPC is created, a default security group is created as well and this cannot
      be deleted. The default security group is created with ingress/egress rules that allow
      _all_ traffic. [AWS Security best practices recommend](https://docs.aws.amazon.com/securityhub/latest/userguide/ec2-controls.html#ec2-2)
      removing these ingress/egress rules in order to restrict access to the default security group.
    `,
        introducedIn: { v2: '2.78.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: `
      To allow all ingress/egress traffic to the VPC default security group you
      can set the \`restrictDefaultSecurityGroup: false\`.
    `,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate a unique id for each RequestValidator added to a method',
        detailsMd: `
      This flag allows multiple RequestValidators to be added to a RestApi when
      providing the \`RequestValidatorOptions\` in the \`addMethod()\` method.

      If the flag is not set then only a single RequestValidator can be added in this way.
      Any additional RequestValidators have to be created directly with \`new RequestValidator\`.
    `,
        introducedIn: { v2: '2.78.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.KMS_ALIAS_NAME_REF]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'KMS Alias name and keyArn will have implicit reference to KMS Key',
        detailsMd: `
      This flag allows an implicit dependency to be created between KMS Alias and KMS Key
      when referencing key.aliasName or key.keyArn.

      If the flag is not set then a raw string is passed as the Alias name and no
      implicit dependencies will be set.
    `,
        introducedIn: { v2: '2.83.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Generate a launch template when creating an AutoScalingGroup',
        detailsMd: `
      Enable this flag to allow AutoScalingGroups to generate a launch template when being created.
      Launch configurations have been deprecated and cannot be created in AWS Accounts created after
      December 31, 2023. Existing 'AutoScalingGroup' properties used for creating a launch configuration
      will now create an equivalent 'launchTemplate'. Alternatively, users can provide an explicit
      'launchTemplate' or 'mixedInstancesPolicy'. When this flag is enabled a 'launchTemplate' will
      attempt to set user data according to the OS of the machine image if explicit user data is not
      provided.
    `,
        introducedIn: { v2: '2.88.0' },
        compatibilityWithOldBehaviorMd: `
      If backwards compatibility needs to be maintained due to an existing autoscaling group
      using a launch config, set this flag to false.
    `,
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Include the stack prefix in the stack name generation process',
        detailsMd: `
      This flag prevents the prefix of a stack from making the stack's name longer than the 128 character limit.

      If the flag is set, the prefix is included in the stack name generation process.
      If the flag is not set, then the prefix of the stack is prepended to the generated stack name.

      **NOTE** - Enabling this flag comes at a **risk**. If you have already deployed stacks, changing the status of this
      feature flag can lead to a change in stacks' name. Changing a stack name mean recreating the whole stack, which
      is not viable in some productive setups.
    `,
        introducedIn: { v2: '2.84.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_DENY_ANONYMOUS_ACCESS]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'EFS denies anonymous clients accesses',
        detailsMd: `
      This flag adds the file system policy that denies anonymous clients
      access to \`efs.FileSystem\`.

      If this flag is not set, \`efs.FileSystem\` will allow all anonymous clients
      that can access over the network.`,
        introducedIn: { v2: '2.93.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'You can pass `allowAnonymousAccess: true` so allow anonymous clients access.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enables support for Multi-AZ with Standby deployment for opensearch domains',
        detailsMd: `
      If this is set, an opensearch domain will automatically be created with
      multi-az with standby enabled.
    `,
        introducedIn: { v2: '2.88.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `capacity.multiAzWithStandbyEnabled: false` to `Domain` construct to restore the old behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.LAMBDA_NODEJS_USE_LATEST_RUNTIME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: 'Enables aws-lambda-nodejs.Function to use the latest available NodeJs runtime as the default',
        detailsMd: `
      If this is set, and a \`runtime\` prop is not passed to, Lambda NodeJs
      functions will us the latest version of the runtime provided by the Lambda
      service. Do not use this if you your lambda function is reliant on dependencies
      shipped as part of the runtime environment.
    `,
        introducedIn: { v2: '2.93.0' },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: 'Pass `runtime: lambda.Runtime.NODEJS_16_X` to `Function` construct to restore the previous behavior.',
    },
    //////////////////////////////////////////////////////////////////////
    [exports.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, mount targets will have a stable logicalId that is linked to the associated subnet.',
        detailsMd: `
      When this feature flag is enabled, each mount target will have a stable
      logicalId that is linked to the associated subnet. If the flag is set to
      false then the logicalIds of the mount targets can change if the number of
      subnets changes.

      Set this flag to false for existing mount targets.
    `,
        introducedIn: { v2: '2.93.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, a scope of InstanceParameterGroup for AuroraClusterInstance with each parameters will change.',
        detailsMd: `
      When this feature flag is enabled, a scope of \`InstanceParameterGroup\` for
      \`AuroraClusterInstance\` with each parameters will change to AuroraClusterInstance
      from AuroraCluster.

      If the flag is set to false then it can only make one \`AuroraClusterInstance\`
      with each \`InstanceParameterGroup\` in the AuroraCluster.
    `,
        introducedIn: { v2: '2.97.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, will always use the arn for identifiers for CfnSourceApiAssociation in the GraphqlApi construct rather than id.',
        detailsMd: `
      When this feature flag is enabled, we use the IGraphqlApi ARN rather than ID when creating or updating CfnSourceApiAssociation in 
      the GraphqlApi construct. Using the ARN allows the association to support an association with a source api or merged api in another account.
      Note that for existing source api associations created with this flag disabled, enabling the flag will lead to a resource replacement. 
    `,
        introducedIn: { v2: '2.97.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, creating an RDS database cluster from a snapshot will only render credentials for snapshot credentials.',
        detailsMd: `
      The \`credentials\` property on the \`DatabaseClusterFromSnapshotProps\`
      interface was deprecated with the new \`snapshotCredentials\` property being
      recommended. Before deprecating \`credentials\`, a secret would be generated
      while rendering credentials if the \`credentials\` property was undefined or
      if a secret wasn't provided via the \`credentials\` property. This behavior
      is replicated with the new \`snapshotCredentials\` property, but the original
      \`credentials\` secret can still be created resulting in an extra database
      secret.
      
      Set this flag to prevent rendering deprecated \`credentials\` and creating an
      extra database secret when only using \`snapshotCredentials\` to create an RDS
      database cluster from a snapshot.
    `,
        introducedIn: { v2: '2.98.0' },
        recommendedValue: true,
    },
    //////////////////////////////////////////////////////////////////////
    [exports.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'When enabled, the CodeCommit source action is using the default branch name \'main\'.',
        detailsMd: `
      When setting up a CodeCommit source action for the source stage of a pipeline, please note that the 
      default branch is \'master\'.
      However, with the activation of this feature flag, the default branch is updated to \'main\'.
    `,
        introducedIn: { v2: '2.103.1' },
        recommendedValue: true,
    },
};
const CURRENT_MV = 'v2';
/**
 * The list of future flags that are now expired. This is going to be used to identify
 * and block usages of old feature flags in the new major version of CDK.
 */
exports.CURRENT_VERSION_EXPIRED_FLAGS = Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.introducedIn[CURRENT_MV] === undefined)
    .map(([name, _]) => name).sort();
/**
 * Flag values that should apply for new projects
 *
 * Add a flag in here (typically with the value `true`), to enable
 * backwards-breaking behavior changes only for new projects.  New projects
 * generated through `cdk init` will include these flags in their generated
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.NEW_PROJECT_CONTEXT = Object.fromEntries(Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.recommendedValue !== flag.defaults?.[CURRENT_MV] && flag.introducedIn[CURRENT_MV])
    .map(([name, flag]) => [name, flag.recommendedValue]));
/**
 * The default values of each of these flags in the current major version.
 *
 * This is the effective value of the flag, unless it's overriden via
 * context.
 *
 * Adding new flags here is only allowed during the pre-release period of a new
 * major version!
 */
exports.CURRENT_VERSION_FLAG_DEFAULTS = Object.fromEntries(Object.entries(exports.FLAGS)
    .filter(([_, flag]) => flag.defaults?.[CURRENT_MV] !== undefined)
    .map(([name, flag]) => [name, flag.defaults?.[CURRENT_MV]]));
function futureFlagDefault(flag) {
    const value = exports.CURRENT_VERSION_FLAG_DEFAULTS[flag] ?? false;
    if (typeof value !== 'boolean') {
        throw new Error(`futureFlagDefault: default type of flag '${flag}' should be boolean, got '${typeof value}'`);
    }
    return value;
}
exports.futureFlagDefault = futureFlagDefault;
// Nobody should have been using any of this, but you never know
/** @deprecated use CURRENT_VERSION_EXPIRED_FLAGS instead */
exports.FUTURE_FLAGS_EXPIRED = exports.CURRENT_VERSION_EXPIRED_FLAGS;
/** @deprecated use NEW_PROJECT_CONTEXT instead */
exports.FUTURE_FLAGS = Object.fromEntries(Object.entries(exports.NEW_PROJECT_CONTEXT)
    .filter(([_, v]) => typeof v === 'boolean'));
/** @deprecated use NEW_PROJECT_CONTEXT instead */
exports.NEW_PROJECT_DEFAULT_CONTEXT = Object.fromEntries(Object.entries(exports.NEW_PROJECT_CONTEXT)
    .filter(([_, v]) => typeof v !== 'boolean'));
//# sourceMappingURL=data:application/json;base64,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