"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareVersions = exports.MAGIC_V2NEXT = exports.FlagType = void 0;
var FlagType;
(function (FlagType) {
    /**
     * Change the default behavior of the API
     *
     * The old behavior is not disrecommended, and possible to achieve with source
     * code changes. Also valid for changes that don't affect CloudFormation, but
     * the CXAPI contract.
     */
    FlagType[FlagType["ApiDefault"] = 0] = "ApiDefault";
    /**
     * Address a bug/introduce a recommended change
     *
     * The old behavior is no longer recommended. The only way to achieve it is by
     * keeping the flag at the legacy value.
     */
    FlagType[FlagType["BugFix"] = 1] = "BugFix";
    /**
     * Advertise the presence of this context option in `cdk.json`
     */
    FlagType[FlagType["VisibleContext"] = 2] = "VisibleContext";
})(FlagType || (exports.FlagType = FlagType = {}));
;
;
/**
 * The magic value that will be substituted at version bump time with the actual
 * new V2 version.
 *
 * Do not import this constant in the `features.ts` file, or the substitution
 * process won't work.
 */
exports.MAGIC_V2NEXT = 'V2NEXT';
/**
 * Compare two versions, returning -1, 0, or 1.
 */
function compareVersions(a, b) {
    if (a === b) {
        return 0;
    }
    if (a === undefined) {
        return -1;
    }
    if (b === undefined) {
        return 1;
    }
    const as = a.split('.').map(x => parseInt(x, 10));
    const bs = b.split('.').map(x => parseInt(x, 10));
    if (a === exports.MAGIC_V2NEXT) {
        return bs[0] <= 2 ? 1 : -1;
    }
    if (b === exports.MAGIC_V2NEXT) {
        return as[0] <= 2 ? -1 : 1;
    }
    for (let i = 0; i < Math.min(as.length, bs.length); i++) {
        if (as[i] < bs[i]) {
            return -1;
        }
        if (as[i] > bs[i]) {
            return 1;
        }
    }
    return as.length - bs.length;
}
exports.compareVersions = compareVersions;
//# sourceMappingURL=data:application/json;base64,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