# Generated by Django 4.1.2 on 2023-01-24 15:22
from django.db import migrations
from tqdm import tqdm


def update_new_appt_type(apps, schema_editor):
    appointment_type_model_cls = apps.get_model("edc_appointment.appointmenttype")
    appointment_model_cls = apps.get_model("edc_appointment.appointment")
    appointment_model_cls.skip_history_when_saving = True
    historical_model_cls = apps.get_model("edc_appointment.historicalappointment")
    total = appointment_model_cls.objects.all().count()
    for appointment in tqdm(appointment_model_cls.objects.all(), total=total):
        appt_type = appointment_type_model_cls.objects.get(name=appointment.appt_type_old)
        appointment.appt_type = appt_type
        appointment.save(update_fields=["appt_type"])

    for appointment in tqdm(historical_model_cls.objects.all(), total=total):
        appt_type = appointment_type_model_cls.objects.get(name=appointment.appt_type_old)
        appointment.appt_type = appt_type
        appointment.save(update_fields=["appt_type"])


class Migration(migrations.Migration):
    dependencies = [
        ("edc_appointment", "0035_rename_appointment_appt_type"),
    ]

    operations = [migrations.RunPython(update_new_appt_type)]
